# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PublicNetworksGet200ResponseInner(BaseModel):
    """
    PublicNetworksGet200ResponseInner
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    active: Optional[Any] = None
    chain_like: StrictStr
    address_regex: Optional[StrictStr] = None
    withdrawal_fee_usd: Union[StrictFloat, StrictInt]
    min_deposit_usd: Union[StrictFloat, StrictInt]
    logo_url: StrictStr
    min_confirmations: Union[StrictFloat, StrictInt]
    memo_support: Optional[Any] = None
    explorer_txid: StrictStr
    explorer_address: StrictStr
    native_currency: StrictStr
    __properties: ClassVar[List[str]] = ["id", "name", "active", "chain_like", "address_regex", "withdrawal_fee_usd", "min_deposit_usd", "logo_url", "min_confirmations", "memo_support", "explorer_txid", "explorer_address", "native_currency"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicNetworksGet200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if active (nullable) is None
        # and model_fields_set contains the field
        if self.active is None and "active" in self.model_fields_set:
            _dict['active'] = None

        # set to None if memo_support (nullable) is None
        # and model_fields_set contains the field
        if self.memo_support is None and "memo_support" in self.model_fields_set:
            _dict['memo_support'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicNetworksGet200ResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "chain_like": obj.get("chain_like"),
            "address_regex": obj.get("address_regex"),
            "withdrawal_fee_usd": obj.get("withdrawal_fee_usd"),
            "min_deposit_usd": obj.get("min_deposit_usd"),
            "logo_url": obj.get("logo_url"),
            "min_confirmations": obj.get("min_confirmations"),
            "memo_support": obj.get("memo_support"),
            "explorer_txid": obj.get("explorer_txid"),
            "explorer_address": obj.get("explorer_address"),
            "native_currency": obj.get("native_currency")
        })
        return _obj


