# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from exapi_client_python.models.public_currencies_get200_response_inner_networks_inner import PublicCurrenciesGet200ResponseInnerNetworksInner
from typing import Optional, Set
from typing_extensions import Self

class PublicCurrenciesGet200ResponseInner(BaseModel):
    """
    PublicCurrenciesGet200ResponseInner
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    precision: Union[StrictFloat, StrictInt]
    deposit_enabled: Optional[Any] = None
    withdrawal_enabled: Optional[Any] = None
    value_usd: StrictStr
    logo_url: StrictStr
    networks: List[PublicCurrenciesGet200ResponseInnerNetworksInner]
    lp_token_of: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "precision", "deposit_enabled", "withdrawal_enabled", "value_usd", "logo_url", "networks", "lp_token_of"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicCurrenciesGet200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in networks (list)
        _items = []
        if self.networks:
            for _item_networks in self.networks:
                if _item_networks:
                    _items.append(_item_networks.to_dict())
            _dict['networks'] = _items
        # set to None if deposit_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.deposit_enabled is None and "deposit_enabled" in self.model_fields_set:
            _dict['deposit_enabled'] = None

        # set to None if withdrawal_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.withdrawal_enabled is None and "withdrawal_enabled" in self.model_fields_set:
            _dict['withdrawal_enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicCurrenciesGet200ResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "precision": obj.get("precision"),
            "deposit_enabled": obj.get("deposit_enabled"),
            "withdrawal_enabled": obj.get("withdrawal_enabled"),
            "value_usd": obj.get("value_usd"),
            "logo_url": obj.get("logo_url"),
            "networks": [PublicCurrenciesGet200ResponseInnerNetworksInner.from_dict(_item) for _item in obj["networks"]] if obj.get("networks") is not None else None,
            "lp_token_of": obj.get("lp_token_of")
        })
        return _obj


