# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from exapi_client_python.models.public_currencies_get200_response_inner import PublicCurrenciesGet200ResponseInner
from exapi_client_python.models.public_networks_get200_response_inner import PublicNetworksGet200ResponseInner
from typing import Optional, Set
from typing_extensions import Self

class PrivateDepositAddressGet200Response(BaseModel):
    """
    PrivateDepositAddressGet200Response
    """ # noqa: E501
    active: Optional[Any] = None
    address: StrictStr
    memo: Optional[StrictStr] = None
    min_deposit_amount: StrictStr
    currency_details: PublicCurrenciesGet200ResponseInner = Field(alias="currencyDetails")
    network_details: PublicNetworksGet200ResponseInner = Field(alias="networkDetails")
    __properties: ClassVar[List[str]] = ["active", "address", "memo", "min_deposit_amount", "currencyDetails", "networkDetails"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateDepositAddressGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of currency_details
        if self.currency_details:
            _dict['currencyDetails'] = self.currency_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_details
        if self.network_details:
            _dict['networkDetails'] = self.network_details.to_dict()
        # set to None if active (nullable) is None
        # and model_fields_set contains the field
        if self.active is None and "active" in self.model_fields_set:
            _dict['active'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateDepositAddressGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "address": obj.get("address"),
            "memo": obj.get("memo"),
            "min_deposit_amount": obj.get("min_deposit_amount"),
            "currencyDetails": PublicCurrenciesGet200ResponseInner.from_dict(obj["currencyDetails"]) if obj.get("currencyDetails") is not None else None,
            "networkDetails": PublicNetworksGet200ResponseInner.from_dict(obj["networkDetails"]) if obj.get("networkDetails") is not None else None
        })
        return _obj


