# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Union
from exapi_client_python.models.public_funds_transparency_get200_response_funds_value_value import PublicFundsTransparencyGet200ResponseFundsValueValue
from exapi_client_python.models.public_funds_transparency_get200_response_stats_value import PublicFundsTransparencyGet200ResponseStatsValue
from typing import Optional, Set
from typing_extensions import Self

class PublicFundsTransparencyGet200Response(BaseModel):
    """
    PublicFundsTransparencyGet200Response
    """ # noqa: E501
    timestamp: Union[StrictFloat, StrictInt]
    funds: Dict[str, Dict[str, PublicFundsTransparencyGet200ResponseFundsValueValue]]
    stats: Dict[str, PublicFundsTransparencyGet200ResponseStatsValue]
    addresses_labels: Dict[str, StrictStr]
    __properties: ClassVar[List[str]] = ["timestamp", "funds", "stats", "addresses_labels"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicFundsTransparencyGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in funds (dict)
        _field_dict = {}
        if self.funds:
            for _key_funds in self.funds:
                if self.funds[_key_funds]:
                    _field_dict[_key_funds] = self.funds[_key_funds].to_dict()
            _dict['funds'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in stats (dict)
        _field_dict = {}
        if self.stats:
            for _key_stats in self.stats:
                if self.stats[_key_stats]:
                    _field_dict[_key_stats] = self.stats[_key_stats].to_dict()
            _dict['stats'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicFundsTransparencyGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamp": obj.get("timestamp"),
            "funds": dict(
                (_k, dict(
                    (_ik, PublicFundsTransparencyGet200ResponseFundsValueValue.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("funds").items()
            )
            if obj.get("funds") is not None
            else None,
            "stats": dict(
                (_k, PublicFundsTransparencyGet200ResponseStatsValue.from_dict(_v))
                for _k, _v in obj["stats"].items()
            )
            if obj.get("stats") is not None
            else None,
            "addresses_labels": obj.get("addresses_labels")
        })
        return _obj


