# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, Optional
from exapi_client_python.models.public_currencies_get200_response_inner import PublicCurrenciesGet200ResponseInner
from exapi_client_python.models.public_networks_get200_response_inner import PublicNetworksGet200ResponseInner
from typing import Optional, Set
from typing_extensions import Self

class PrivateWithdrawalsDetailGet200Response(BaseModel):
    """
    PrivateWithdrawalsDetailGet200Response
    """ # noqa: E501
    currency: PublicCurrenciesGet200ResponseInner
    network: PublicNetworksGet200ResponseInner
    balance: StrictStr
    fee_usd: StrictStr
    fee_in_currency: StrictStr
    max_withdraw_exchange: StrictStr
    available_hot: Dict[str, StrictStr]
    available_hot_and_cold: Dict[str, StrictStr]
    address_regex: StrictStr
    min_withdraw_amount: StrictStr
    is_memo_required: Optional[Any] = None
    __properties: ClassVar[List[str]] = ["currency", "network", "balance", "fee_usd", "fee_in_currency", "max_withdraw_exchange", "available_hot", "available_hot_and_cold", "address_regex", "min_withdraw_amount", "is_memo_required"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsDetailGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of currency
        if self.currency:
            _dict['currency'] = self.currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # set to None if is_memo_required (nullable) is None
        # and model_fields_set contains the field
        if self.is_memo_required is None and "is_memo_required" in self.model_fields_set:
            _dict['is_memo_required'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsDetailGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": PublicCurrenciesGet200ResponseInner.from_dict(obj["currency"]) if obj.get("currency") is not None else None,
            "network": PublicNetworksGet200ResponseInner.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "balance": obj.get("balance"),
            "fee_usd": obj.get("fee_usd"),
            "fee_in_currency": obj.get("fee_in_currency"),
            "max_withdraw_exchange": obj.get("max_withdraw_exchange"),
            "available_hot": obj.get("available_hot"),
            "available_hot_and_cold": obj.get("available_hot_and_cold"),
            "address_regex": obj.get("address_regex"),
            "min_withdraw_amount": obj.get("min_withdraw_amount"),
            "is_memo_required": obj.get("is_memo_required")
        })
        return _obj


