# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from exapi_client_python.models.public_exk_config_get200_response_routes_value import PublicExkConfigGet200ResponseRoutesValue
from exapi_client_python.models.public_exk_config_get200_response_user_levels_inner import PublicExkConfigGet200ResponseUserLevelsInner
from exapi_client_python.models.public_exk_config_get200_response_weekly_dist import PublicExkConfigGet200ResponseWeeklyDist
from typing import Optional, Set
from typing_extensions import Self

class PublicExkConfigGet200Response(BaseModel):
    """
    PublicExkConfigGet200Response
    """ # noqa: E501
    circulating_supply: Union[StrictFloat, StrictInt]
    last_reserve_value_usd: Union[StrictFloat, StrictInt]
    mint_rate: Union[StrictFloat, StrictInt]
    lp_share_percent_to_exk: Union[StrictFloat, StrictInt]
    routes: Dict[str, PublicExkConfigGet200ResponseRoutesValue]
    user_levels: List[PublicExkConfigGet200ResponseUserLevelsInner]
    weekly_dist: PublicExkConfigGet200ResponseWeeklyDist
    __properties: ClassVar[List[str]] = ["circulating_supply", "last_reserve_value_usd", "mint_rate", "lp_share_percent_to_exk", "routes", "user_levels", "weekly_dist"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicExkConfigGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in routes (dict)
        _field_dict = {}
        if self.routes:
            for _key_routes in self.routes:
                if self.routes[_key_routes]:
                    _field_dict[_key_routes] = self.routes[_key_routes].to_dict()
            _dict['routes'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in user_levels (list)
        _items = []
        if self.user_levels:
            for _item_user_levels in self.user_levels:
                if _item_user_levels:
                    _items.append(_item_user_levels.to_dict())
            _dict['user_levels'] = _items
        # override the default output from pydantic by calling `to_dict()` of weekly_dist
        if self.weekly_dist:
            _dict['weekly_dist'] = self.weekly_dist.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicExkConfigGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "circulating_supply": obj.get("circulating_supply"),
            "last_reserve_value_usd": obj.get("last_reserve_value_usd"),
            "mint_rate": obj.get("mint_rate"),
            "lp_share_percent_to_exk": obj.get("lp_share_percent_to_exk"),
            "routes": dict(
                (_k, PublicExkConfigGet200ResponseRoutesValue.from_dict(_v))
                for _k, _v in obj["routes"].items()
            )
            if obj.get("routes") is not None
            else None,
            "user_levels": [PublicExkConfigGet200ResponseUserLevelsInner.from_dict(_item) for _item in obj["user_levels"]] if obj.get("user_levels") is not None else None,
            "weekly_dist": PublicExkConfigGet200ResponseWeeklyDist.from_dict(obj["weekly_dist"]) if obj.get("weekly_dist") is not None else None
        })
        return _obj


