# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PrivateWithdrawalsFinishPost200Response(BaseModel):
    """
    PrivateWithdrawalsFinishPost200Response
    """ # noqa: E501
    id: StrictStr
    currency: StrictStr
    amount: StrictStr
    user_fee: StrictStr
    message: StrictStr
    address: StrictStr
    from_address: StrictStr
    network: StrictStr
    memo: Optional[StrictStr] = None
    txid: Optional[StrictStr] = None
    status: StrictStr
    timestamp: Union[StrictFloat, StrictInt]
    __properties: ClassVar[List[str]] = ["id", "currency", "amount", "user_fee", "message", "address", "from_address", "network", "memo", "txid", "status", "timestamp"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'processing', 'completed', 'failed', 'cancelled']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'cancelled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsFinishPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsFinishPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "user_fee": obj.get("user_fee"),
            "message": obj.get("message"),
            "address": obj.get("address"),
            "from_address": obj.get("from_address"),
            "network": obj.get("network"),
            "memo": obj.get("memo"),
            "txid": obj.get("txid"),
            "status": obj.get("status"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


