# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional, Union
from exapi_client_python.models.public_currencies_get200_response_inner import PublicCurrenciesGet200ResponseInner
from exapi_client_python.models.public_networks_get200_response_inner import PublicNetworksGet200ResponseInner
from typing import Optional, Set
from typing_extensions import Self

class PrivateWithdrawalsPreparePost200Response(BaseModel):
    """
    PrivateWithdrawalsPreparePost200Response
    """ # noqa: E501
    currency: PublicCurrenciesGet200ResponseInner
    amount_you_receive: StrictStr
    fee: StrictStr
    amount_you_pay: StrictStr
    address: StrictStr
    network: PublicNetworksGet200ResponseInner
    memo: Optional[StrictStr] = None
    payload: StrictStr
    expire_in_ms: Union[StrictFloat, StrictInt]
    __properties: ClassVar[List[str]] = ["currency", "amount_you_receive", "fee", "amount_you_pay", "address", "network", "memo", "payload", "expire_in_ms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsPreparePost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of currency
        if self.currency:
            _dict['currency'] = self.currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateWithdrawalsPreparePost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": PublicCurrenciesGet200ResponseInner.from_dict(obj["currency"]) if obj.get("currency") is not None else None,
            "amount_you_receive": obj.get("amount_you_receive"),
            "fee": obj.get("fee"),
            "amount_you_pay": obj.get("amount_you_pay"),
            "address": obj.get("address"),
            "network": PublicNetworksGet200ResponseInner.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "memo": obj.get("memo"),
            "payload": obj.get("payload"),
            "expire_in_ms": obj.get("expire_in_ms")
        })
        return _obj


