# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from exapi_client_python.models.public_exk_config_get200_response_routes_value_logs_inner import PublicExkConfigGet200ResponseRoutesValueLogsInner
from typing import Optional, Set
from typing_extensions import Self

class PublicExkConfigGet200ResponseRoutesValue(BaseModel):
    """
    PublicExkConfigGet200ResponseRoutesValue
    """ # noqa: E501
    weight: Union[StrictFloat, StrictInt]
    description: StrictStr
    free_amount: Union[StrictFloat, StrictInt]
    locked_amount: Union[StrictFloat, StrictInt]
    logs: List[PublicExkConfigGet200ResponseRoutesValueLogsInner]
    __properties: ClassVar[List[str]] = ["weight", "description", "free_amount", "locked_amount", "logs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicExkConfigGet200ResponseRoutesValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in logs (list)
        _items = []
        if self.logs:
            for _item_logs in self.logs:
                if _item_logs:
                    _items.append(_item_logs.to_dict())
            _dict['logs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicExkConfigGet200ResponseRoutesValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "weight": obj.get("weight"),
            "description": obj.get("description"),
            "free_amount": obj.get("free_amount"),
            "locked_amount": obj.get("locked_amount"),
            "logs": [PublicExkConfigGet200ResponseRoutesValueLogsInner.from_dict(_item) for _item in obj["logs"]] if obj.get("logs") is not None else None
        })
        return _obj


