# exec-python

Minimal engine to execute python code generated by LLMs, with a lot of customisation options.

## Requirements

- Python 3.13+
- [uv](https://docs.astral.sh/uv/) (for development & testing)

## Installation

```bash
pip install exec-python 
```

## Running the tests

```bash
uv run test_engine.py
```


## Usage

### Quick Start 

```python
from exec_python import execute_python_code

def pair_sum(x: list[int], y: list[int]) -> list[int]:
    assert isinstance(x, list)
    assert isinstance(y, list)
    assert len(x) == len(y)
    return [x[i] + y[i] for i in range(len(x))]

code = """
x = [1, 2]
y = [2, 3]
z = pair_sum(x, y)
k = pair_sum(z, z)
"""

results = execute_python_code(
    code = code,
    functions=[pair_sum]
)
print(results)
```
Running the above code will output:

```
{
  "function_results": {
    "pair_sum": ["z","k"]
  },
  "variables": {
    "x": [1,2],
    "y": [2,3],
    "z": [3,5],
    "k": [6,10]
  },
  "errors": []
}
```
