'''
Date         : 2023-10-11 13:39:36
Author       : BDFD,bdfd2005@gmail.com
Github       : https://github.com/bdfd
LastEditTime : 2023-11-01 14:03:31
LastEditors  : BDFD
Description  : 
FilePath     : \execdata\data_preprocess.py
Copyright (c) 2023 by BDFD, All Rights Reserved. 
'''

import numpy as np
import pandas as pd
from sklearn.preprocessing import LabelEncoder


def drop_columns(df, del_columns_list):
    if isinstance(del_columns_list, str):
        del_columns_list = [del_columns_list]
    elif isinstance(del_columns_list, list):
        del_columns_list = del_columns_list
    else:
        return print("input is not list or str! please redo the function with correct parameter.")
    for column in del_columns_list:
        df = df.drop(column, axis=1)
    return df


def sort_categorical_feature(categorical_features):
    if isinstance(categorical_features, list):
        categorical_features = categorical_features
        categorical_features.sort()
        # print(type(categorical_features))
    else:
        categorical_features = list(categorical_features)
        categorical_features = categorical_features
        categorical_features.sort()
        # print(type(categorical_features))
    return categorical_features


def fit_label_encode(df, categorical_features):
    label_encoders = []
    for feature in categorical_features:
        Le = LabelEncoder()
        Le.fit(df[feature])
        # print(type(Le))
        label_encoders.append(Le)
        # print('The Feature', feature, ',with value', Le.classes_)
    return label_encoders


def transform_label_encode(df, categorical_features, label_encoders):
    # Transform the new data using the fitted LabelEncoders
    transformed_new_data = []
    for i in range(len(categorical_features)):
        le = label_encoders[i]
        feature = categorical_features[i]
        # print(i, feature)
        # print(i, label_encoders[i].classes_)
        # print(i, categorical_features[i])
        transformed_col = le.transform(df[categorical_features[i]])
        df[feature] = transformed_col
        # print(transformed_col)
        transformed_new_data.append(transformed_col)
    df_transformed = pd.DataFrame(transformed_new_data).transpose()
    df_transformed.columns = categorical_features
    return df_transformed


def inverse_label_encode(df, categorical_features, label_encoders):
    # Convert the transformed data back to the original form
    inverse_transformed_data = []
    for i in range(len(categorical_features)):
        le = label_encoders[i]
        # print(label_encoders[i].classes_)
        # print(feature)
        inverse_transformed_col = le.inverse_transform(
            df[categorical_features[i]])
        inverse_transformed_data.append(inverse_transformed_col)
    # Display the inverse transformed data
    df_inverse_transformed = pd.DataFrame(inverse_transformed_data).transpose()
    df_inverse_transformed.columns = categorical_features
    return df_inverse_transformed
