#!/usr/bin/env python
#

from __future__ import print_function


def default_sets():
    return [
        [chr(ord('A') + i) for i in range(26)],
        [chr(ord('a') + i) for i in range(26)],
        [chr(ord('0') + i) for i in range(10)],
    ]


def __create(length, sets):
    i = [0, 0, 0]
    l = 0
    while True:
        for o in range(len(sets)):
            yield sets[o][i[o]]

        l += len(sets)
        if l >= length:
            break

        o = -1
        i[o] += 1
        while i[o] == len(sets[o]):
            i[o] = 0
            i[o - 1] += 1
            o -= 1


def mult(ls):
    p = 0
    for i in ls:
        p = (i * (1 if not p else p))
    return p


def create(length=-1, sets=None):
    if not sets:
        sets = default_sets()

    assert(3 == len(sets))

    limit = mult([len(sets[i]) for i in range(len(sets))] + [len(sets)])
    if 0 > length:
        length = limit

    assert(limit >= length)

    return ''.join(__create(length, sets))[:length]


def offset(string, o_length=-1, sets=None):
    if not sets:
        sets = default_sets()

    assert(3 == len(sets))

    s = create(length=o_length, sets=sets)
    if string in s:
        return s.index(string)

    return -1
