import sys
from typing import Any, overload

if sys.version_info >= (3, 10):
    from typing import TypeAlias
else:
    from typing_extensions import TypeAlias
Unknown: TypeAlias = Any

class CppExceptionPtr: ...

class Antlr4ErrorListener:
    def syntaxError(
        self,
        recognizer: Antlr4Recognizer,
        offendingSymbol: Antlr4Token,
        line: int,
        charPositionInLine: int,
        msg: str,
        e: CppExceptionPtr,
    ) -> None: ...

class Antlr4Recognizer: ...
class Antlr4ParseTree: ...
class Antlr4RuleContext(Antlr4ParseTree): ...

class Antlr4ParserRuleContext(Antlr4RuleContext):
    @property
    def start(self) -> Antlr4Token: ...
    @property
    def stop(self) -> Antlr4Token: ...

class Antlr4Token:
    def __str__(self) -> str: ...
    @property
    def type(self) -> int: ...
    @property
    def line(self) -> int: ...
    @property
    def charPositionInLine(self) -> int: ...
    @property
    def channel(self) -> int: ...
    @property
    def tokenIndex(self) -> int: ...
    @property
    def stopIndex(self) -> int: ...
    @property
    def text(self) -> str: ...

class Antlr4TreeTerminalNode:
    def __str__(self) -> str: ...
    @property
    def symbol(self) -> Antlr4Token: ...

class ExplorerScriptParser:
    class StartContext(Antlr4ParserRuleContext):
        def EOF(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        @overload
        def constant_assign(self) -> list[ExplorerScriptParser.Constant_assignContext]: ...
        @overload
        def constant_assign(self, i: int) -> ExplorerScriptParser.Constant_assignContext: ...
        @overload
        def funcdef(self) -> list[ExplorerScriptParser.FuncdefContext]: ...
        @overload
        def funcdef(self, i: int) -> ExplorerScriptParser.FuncdefContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def import_stmt(self) -> list[ExplorerScriptParser.Import_stmtContext]: ...
        @overload
        def import_stmt(self, i: int) -> ExplorerScriptParser.Import_stmtContext: ...
        @overload
        def macrodef(self) -> list[ExplorerScriptParser.MacrodefContext]: ...
        @overload
        def macrodef(self, i: int) -> ExplorerScriptParser.MacrodefContext: ...

    class Import_stmtContext(Antlr4ParserRuleContext):
        def IMPORT(self) -> Antlr4TreeTerminalNode: ...
        def STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Constant_assignContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def CONST(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class MacrodefContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def MACRO(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def VARIABLE(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def VARIABLE(self, i: int) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def func_suite(self) -> ExplorerScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...

    class StmtContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def constant_assign(self) -> ExplorerScriptParser.Constant_assignContext: ...
        def ctx_block(self) -> ExplorerScriptParser.Ctx_blockContext: ...
        def for_block(self) -> ExplorerScriptParser.For_blockContext: ...
        def forever_block(self) -> ExplorerScriptParser.Forever_blockContext: ...
        def getRuleIndex(self) -> int: ...
        def if_block(self) -> ExplorerScriptParser.If_blockContext: ...
        def macro_call(self) -> ExplorerScriptParser.Macro_callContext: ...
        def message_switch_block(self) -> ExplorerScriptParser.Message_switch_blockContext: ...
        def simple_stmt(self) -> ExplorerScriptParser.Simple_stmtContext: ...
        def switch_block(self) -> ExplorerScriptParser.Switch_blockContext: ...
        def while_block(self) -> ExplorerScriptParser.While_blockContext: ...

    class Simple_stmtContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def assignment(self) -> ExplorerScriptParser.AssignmentContext: ...
        def call(self) -> ExplorerScriptParser.CallContext: ...
        def cntrl_stmt(self) -> ExplorerScriptParser.Cntrl_stmtContext: ...
        def getRuleIndex(self) -> int: ...
        def jump(self) -> ExplorerScriptParser.JumpContext: ...
        def label(self) -> ExplorerScriptParser.LabelContext: ...
        def operation(self) -> ExplorerScriptParser.OperationContext: ...

    class Cntrl_stmtContext(Antlr4ParserRuleContext):
        def BREAK(self) -> Antlr4TreeTerminalNode: ...
        def BREAK_LOOP(self) -> Antlr4TreeTerminalNode: ...
        def CONTINUE(self) -> Antlr4TreeTerminalNode: ...
        def END(self) -> Antlr4TreeTerminalNode: ...
        def HOLD(self) -> Antlr4TreeTerminalNode: ...
        def RETURN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class JumpContext(Antlr4ParserRuleContext):
        def AT(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def JUMP(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class CallContext(Antlr4ParserRuleContext):
        def AT(self) -> Antlr4TreeTerminalNode: ...
        def CALL(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Macro_callContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def MACRO_CALL(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def arglist(self) -> ExplorerScriptParser.ArglistContext: ...
        def getRuleIndex(self) -> int: ...

    class Ctx_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def WITH(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def ctx_header(self) -> ExplorerScriptParser.Ctx_headerContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def simple_stmt(self) -> list[ExplorerScriptParser.Simple_stmtContext]: ...
        @overload
        def simple_stmt(self, i: int) -> ExplorerScriptParser.Simple_stmtContext: ...

    class If_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def IF(self) -> Antlr4TreeTerminalNode: ...
        def NOT(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def OR(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def OR(self, i: int) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def else_block(self) -> ExplorerScriptParser.Else_blockContext: ...
        @overload
        def elseif_block(self) -> list[ExplorerScriptParser.Elseif_blockContext]: ...
        @overload
        def elseif_block(self, i: int) -> ExplorerScriptParser.Elseif_blockContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def if_header(self) -> list[ExplorerScriptParser.If_headerContext]: ...
        @overload
        def if_header(self, i: int) -> ExplorerScriptParser.If_headerContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class Elseif_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def ELSEIF(self) -> Antlr4TreeTerminalNode: ...
        def NOT(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def OR(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def OR(self, i: int) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def if_header(self) -> list[ExplorerScriptParser.If_headerContext]: ...
        @overload
        def if_header(self, i: int) -> ExplorerScriptParser.If_headerContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class Else_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def ELSE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class If_headerContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def if_h_bit(self) -> ExplorerScriptParser.If_h_bitContext: ...
        def if_h_negatable(self) -> ExplorerScriptParser.If_h_negatableContext: ...
        def if_h_op(self) -> ExplorerScriptParser.If_h_opContext: ...
        def if_h_scn(self) -> ExplorerScriptParser.If_h_scnContext: ...
        def operation(self) -> ExplorerScriptParser.OperationContext: ...

    class If_h_negatableContext(Antlr4ParserRuleContext):
        def DEBUG(self) -> Antlr4TreeTerminalNode: ...
        def EDIT(self) -> Antlr4TreeTerminalNode: ...
        def NOT(self) -> Antlr4TreeTerminalNode: ...
        def VARIATION(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class If_h_opContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def conditional_operator(self) -> ExplorerScriptParser.Conditional_operatorContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def primitive(self) -> list[ExplorerScriptParser.PrimitiveContext]: ...
        @overload
        def primitive(self, i: int) -> ExplorerScriptParser.PrimitiveContext: ...
        def value_of(self) -> ExplorerScriptParser.Value_ofContext: ...

    class If_h_bitContext(Antlr4ParserRuleContext):
        def CLOSE_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def NOT(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class If_h_scnContext(Antlr4ParserRuleContext):
        def CLOSE_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def COMMA(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def INTEGER(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def INTEGER(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def conditional_operator(self) -> ExplorerScriptParser.Conditional_operatorContext: ...
        def getRuleIndex(self) -> int: ...
        def scn_var(self) -> ExplorerScriptParser.Scn_varContext: ...

    class Switch_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def SWITCH(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        @overload
        def default_(self) -> list[ExplorerScriptParser.DefaultContext]: ...
        @overload
        def default_(self, i: int) -> ExplorerScriptParser.DefaultContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def single_case_block(self) -> list[ExplorerScriptParser.Single_case_blockContext]: ...
        @overload
        def single_case_block(self, i: int) -> ExplorerScriptParser.Single_case_blockContext: ...
        def switch_header(self) -> ExplorerScriptParser.Switch_headerContext: ...

    class Message_switch_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def MESSAGE_SWITCH_MONOLOGUE(self) -> Antlr4TreeTerminalNode: ...
        def MESSAGE_SWITCH_TALK(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        @overload
        def default_(self) -> list[ExplorerScriptParser.DefaultContext]: ...
        @overload
        def default_(self, i: int) -> ExplorerScriptParser.DefaultContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...
        @overload
        def single_case_block(self) -> list[ExplorerScriptParser.Single_case_blockContext]: ...
        @overload
        def single_case_block(self, i: int) -> ExplorerScriptParser.Single_case_blockContext: ...

    class Single_case_blockContext(Antlr4ParserRuleContext):
        def CASE(self) -> Antlr4TreeTerminalNode: ...
        def COLON(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def case_header(self) -> ExplorerScriptParser.Case_headerContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class DefaultContext(Antlr4ParserRuleContext):
        def COLON(self) -> Antlr4TreeTerminalNode: ...
        def DEFAULT(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class Switch_headerContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def operation(self) -> ExplorerScriptParser.OperationContext: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...
        def switch_h_dungeon_mode(self) -> ExplorerScriptParser.Switch_h_dungeon_modeContext: ...
        def switch_h_random(self) -> ExplorerScriptParser.Switch_h_randomContext: ...
        def switch_h_scn(self) -> ExplorerScriptParser.Switch_h_scnContext: ...
        def switch_h_sector(self) -> ExplorerScriptParser.Switch_h_sectorContext: ...

    class Switch_h_scnContext(Antlr4ParserRuleContext):
        def CLOSE_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def scn_var(self) -> ExplorerScriptParser.Scn_varContext: ...

    class Switch_h_randomContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def RANDOM(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Switch_h_dungeon_modeContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def DUNGEON_MODE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Switch_h_sectorContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def SECTOR(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Case_headerContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def case_h_menu(self) -> ExplorerScriptParser.Case_h_menuContext: ...
        def case_h_menu2(self) -> ExplorerScriptParser.Case_h_menu2Context: ...
        def case_h_op(self) -> ExplorerScriptParser.Case_h_opContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Case_h_menuContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def MENU(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Case_h_menu2Context(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def MENU2(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Case_h_opContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def conditional_operator(self) -> ExplorerScriptParser.Conditional_operatorContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...
        def value_of(self) -> ExplorerScriptParser.Value_ofContext: ...

    class Forever_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def FOREVER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class For_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def FOR(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def if_header(self) -> ExplorerScriptParser.If_headerContext: ...
        @overload
        def simple_stmt(self) -> list[ExplorerScriptParser.Simple_stmtContext]: ...
        @overload
        def simple_stmt(self, i: int) -> ExplorerScriptParser.Simple_stmtContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class While_blockContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def NOT(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def WHILE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def if_header(self) -> ExplorerScriptParser.If_headerContext: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class AssignmentContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def assignment_adv_log(self) -> ExplorerScriptParser.Assignment_adv_logContext: ...
        def assignment_clear(self) -> ExplorerScriptParser.Assignment_clearContext: ...
        def assignment_dungeon_mode(self) -> ExplorerScriptParser.Assignment_dungeon_modeContext: ...
        def assignment_initial(self) -> ExplorerScriptParser.Assignment_initialContext: ...
        def assignment_regular(self) -> ExplorerScriptParser.Assignment_regularContext: ...
        def assignment_reset(self) -> ExplorerScriptParser.Assignment_resetContext: ...
        def assignment_scn(self) -> ExplorerScriptParser.Assignment_scnContext: ...
        def getRuleIndex(self) -> int: ...

    class Assignment_regularContext(Antlr4ParserRuleContext):
        def CLOSE_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def assign_operator(self) -> ExplorerScriptParser.Assign_operatorContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def primitive(self) -> list[ExplorerScriptParser.PrimitiveContext]: ...
        @overload
        def primitive(self, i: int) -> ExplorerScriptParser.PrimitiveContext: ...
        def value_of(self) -> ExplorerScriptParser.Value_ofContext: ...

    class Assignment_clearContext(Antlr4ParserRuleContext):
        def CLEAR(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Assignment_initialContext(Antlr4ParserRuleContext):
        def INIT(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Assignment_resetContext(Antlr4ParserRuleContext):
        def DUNGEON_RESULT(self) -> Antlr4TreeTerminalNode: ...
        def RESET(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def scn_var(self) -> ExplorerScriptParser.Scn_varContext: ...

    class Assignment_adv_logContext(Antlr4ParserRuleContext):
        def ADVENTURE_LOG(self) -> Antlr4TreeTerminalNode: ...
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Assignment_dungeon_modeContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def DUNGEON_MODE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def primitive(self) -> list[ExplorerScriptParser.PrimitiveContext]: ...
        @overload
        def primitive(self, i: int) -> ExplorerScriptParser.PrimitiveContext: ...

    class Assignment_scnContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def CLOSE_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def COMMA(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def INTEGER(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def INTEGER(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACKET(self) -> Antlr4TreeTerminalNode: ...
        def SCN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Value_ofContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def VALUE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Scn_varContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def SCN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Conditional_operatorContext(Antlr4ParserRuleContext):
        def CLOSE_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def OP_AND(self) -> Antlr4TreeTerminalNode: ...
        def OP_BICH(self) -> Antlr4TreeTerminalNode: ...
        def OP_EQ(self) -> Antlr4TreeTerminalNode: ...
        def OP_FALSE(self) -> Antlr4TreeTerminalNode: ...
        def OP_GE(self) -> Antlr4TreeTerminalNode: ...
        def OP_LE(self) -> Antlr4TreeTerminalNode: ...
        def OP_NEQ(self) -> Antlr4TreeTerminalNode: ...
        def OP_TRUE(self) -> Antlr4TreeTerminalNode: ...
        def OP_XOR(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Assign_operatorContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def OP_DIVIDE(self) -> Antlr4TreeTerminalNode: ...
        def OP_MINUS(self) -> Antlr4TreeTerminalNode: ...
        def OP_MULTIPLY(self) -> Antlr4TreeTerminalNode: ...
        def OP_PLUS(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class FuncdefContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def coro_def(self) -> ExplorerScriptParser.Coro_defContext: ...
        def for_target_def(self) -> ExplorerScriptParser.For_target_defContext: ...
        def getRuleIndex(self) -> int: ...
        def simple_def(self) -> ExplorerScriptParser.Simple_defContext: ...

    class Simple_defContext(Antlr4ParserRuleContext):
        def DEF(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def func_suite(self) -> ExplorerScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...

    class Coro_defContext(Antlr4ParserRuleContext):
        def CORO(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def func_suite(self) -> ExplorerScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...

    class For_target_defContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def DEF(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def for_target_def_target(self) -> ExplorerScriptParser.For_target_def_targetContext: ...
        def func_suite(self) -> ExplorerScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class PrimitiveContext(Antlr4ParserRuleContext):
        def DECIMAL(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def VARIABLE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def string(self) -> ExplorerScriptParser.StringContext: ...

    class OperationContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def arglist(self) -> ExplorerScriptParser.ArglistContext: ...
        def getRuleIndex(self) -> int: ...
        def inline_ctx(self) -> ExplorerScriptParser.Inline_ctxContext: ...

    class Inline_ctxContext(Antlr4ParserRuleContext):
        def CLOSE_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def ctx_header(self) -> ExplorerScriptParser.Ctx_headerContext: ...
        def getRuleIndex(self) -> int: ...

    class Func_suiteContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def func_alias(self) -> ExplorerScriptParser.Func_aliasContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def stmt(self) -> list[ExplorerScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> ExplorerScriptParser.StmtContext: ...

    class Func_aliasContext(Antlr4ParserRuleContext):
        def ALIAS(self) -> Antlr4TreeTerminalNode: ...
        def PREVIOUS(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class ArglistContext(Antlr4ParserRuleContext):
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def pos_argument(self) -> list[ExplorerScriptParser.Pos_argumentContext]: ...
        @overload
        def pos_argument(self, i: int) -> ExplorerScriptParser.Pos_argumentContext: ...

    class Pos_argumentContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def position_marker(self) -> ExplorerScriptParser.Position_markerContext: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class Position_markerContext(Antlr4ParserRuleContext):
        def CLOSE_SHARP(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def POSITION(self) -> Antlr4TreeTerminalNode: ...
        def STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def position_marker_arg(self) -> list[ExplorerScriptParser.Position_marker_argContext]: ...
        @overload
        def position_marker_arg(self, i: int) -> ExplorerScriptParser.Position_marker_argContext: ...

    class Position_marker_argContext(Antlr4ParserRuleContext):
        def DECIMAL(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class LabelContext(Antlr4ParserRuleContext):
        def AT(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def PARAGRAPH(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class StringContext(Antlr4ParserRuleContext):
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def lang_string(self) -> ExplorerScriptParser.Lang_stringContext: ...
        def string_value(self) -> ExplorerScriptParser.String_valueContext: ...

    class Lang_stringContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def lang_string_argument(self) -> list[ExplorerScriptParser.Lang_string_argumentContext]: ...
        @overload
        def lang_string_argument(self, i: int) -> ExplorerScriptParser.Lang_string_argumentContext: ...

    class Lang_string_argumentContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def string_value(self) -> ExplorerScriptParser.String_valueContext: ...

    class String_valueContext(Antlr4ParserRuleContext):
        def MULTILINE_STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Ctx_headerContext(Antlr4ParserRuleContext):
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> ExplorerScriptParser.PrimitiveContext: ...

    class For_target_def_targetContext(Antlr4ParserRuleContext):
        def FOR(self) -> Antlr4TreeTerminalNode: ...
        def FOR_TARGET(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

class ExplorerScriptBaseVisitor:
    def visitStart(self, context: ExplorerScriptParser.StartContext) -> Any: ...
    def visitImport_stmt(self, context: ExplorerScriptParser.Import_stmtContext) -> Any: ...
    def visitConstant_assign(self, context: ExplorerScriptParser.Constant_assignContext) -> Any: ...
    def visitMacrodef(self, context: ExplorerScriptParser.MacrodefContext) -> Any: ...
    def visitStmt(self, context: ExplorerScriptParser.StmtContext) -> Any: ...
    def visitSimple_stmt(self, context: ExplorerScriptParser.Simple_stmtContext) -> Any: ...
    def visitCntrl_stmt(self, context: ExplorerScriptParser.Cntrl_stmtContext) -> Any: ...
    def visitJump(self, context: ExplorerScriptParser.JumpContext) -> Any: ...
    def visitCall(self, context: ExplorerScriptParser.CallContext) -> Any: ...
    def visitMacro_call(self, context: ExplorerScriptParser.Macro_callContext) -> Any: ...
    def visitCtx_block(self, context: ExplorerScriptParser.Ctx_blockContext) -> Any: ...
    def visitIf_block(self, context: ExplorerScriptParser.If_blockContext) -> Any: ...
    def visitElseif_block(self, context: ExplorerScriptParser.Elseif_blockContext) -> Any: ...
    def visitElse_block(self, context: ExplorerScriptParser.Else_blockContext) -> Any: ...
    def visitIf_header(self, context: ExplorerScriptParser.If_headerContext) -> Any: ...
    def visitIf_h_negatable(self, context: ExplorerScriptParser.If_h_negatableContext) -> Any: ...
    def visitIf_h_op(self, context: ExplorerScriptParser.If_h_opContext) -> Any: ...
    def visitIf_h_bit(self, context: ExplorerScriptParser.If_h_bitContext) -> Any: ...
    def visitIf_h_scn(self, context: ExplorerScriptParser.If_h_scnContext) -> Any: ...
    def visitSwitch_block(self, context: ExplorerScriptParser.Switch_blockContext) -> Any: ...
    def visitMessage_switch_block(self, context: ExplorerScriptParser.Message_switch_blockContext) -> Any: ...
    def visitSingle_case_block(self, context: ExplorerScriptParser.Single_case_blockContext) -> Any: ...
    def visitDefault(self, context: ExplorerScriptParser.DefaultContext) -> Any: ...
    def visitSwitch_header(self, context: ExplorerScriptParser.Switch_headerContext) -> Any: ...
    def visitSwitch_h_scn(self, context: ExplorerScriptParser.Switch_h_scnContext) -> Any: ...
    def visitSwitch_h_random(self, context: ExplorerScriptParser.Switch_h_randomContext) -> Any: ...
    def visitSwitch_h_dungeon_mode(self, context: ExplorerScriptParser.Switch_h_dungeon_modeContext) -> Any: ...
    def visitSwitch_h_sector(self, context: ExplorerScriptParser.Switch_h_sectorContext) -> Any: ...
    def visitCase_header(self, context: ExplorerScriptParser.Case_headerContext) -> Any: ...
    def visitCase_h_menu(self, context: ExplorerScriptParser.Case_h_menuContext) -> Any: ...
    def visitCase_h_menu2(self, context: ExplorerScriptParser.Case_h_menu2Context) -> Any: ...
    def visitCase_h_op(self, context: ExplorerScriptParser.Case_h_opContext) -> Any: ...
    def visitForever_block(self, context: ExplorerScriptParser.Forever_blockContext) -> Any: ...
    def visitFor_block(self, context: ExplorerScriptParser.For_blockContext) -> Any: ...
    def visitWhile_block(self, context: ExplorerScriptParser.While_blockContext) -> Any: ...
    def visitAssignment(self, context: ExplorerScriptParser.AssignmentContext) -> Any: ...
    def visitAssignment_regular(self, context: ExplorerScriptParser.Assignment_regularContext) -> Any: ...
    def visitAssignment_clear(self, context: ExplorerScriptParser.Assignment_clearContext) -> Any: ...
    def visitAssignment_initial(self, context: ExplorerScriptParser.Assignment_initialContext) -> Any: ...
    def visitAssignment_reset(self, context: ExplorerScriptParser.Assignment_resetContext) -> Any: ...
    def visitAssignment_adv_log(self, context: ExplorerScriptParser.Assignment_adv_logContext) -> Any: ...
    def visitAssignment_dungeon_mode(self, context: ExplorerScriptParser.Assignment_dungeon_modeContext) -> Any: ...
    def visitAssignment_scn(self, context: ExplorerScriptParser.Assignment_scnContext) -> Any: ...
    def visitValue_of(self, context: ExplorerScriptParser.Value_ofContext) -> Any: ...
    def visitScn_var(self, context: ExplorerScriptParser.Scn_varContext) -> Any: ...
    def visitConditional_operator(self, context: ExplorerScriptParser.Conditional_operatorContext) -> Any: ...
    def visitAssign_operator(self, context: ExplorerScriptParser.Assign_operatorContext) -> Any: ...
    def visitFuncdef(self, context: ExplorerScriptParser.FuncdefContext) -> Any: ...
    def visitSimple_def(self, context: ExplorerScriptParser.Simple_defContext) -> Any: ...
    def visitCoro_def(self, context: ExplorerScriptParser.Coro_defContext) -> Any: ...
    def visitFor_target_def(self, context: ExplorerScriptParser.For_target_defContext) -> Any: ...
    def visitPrimitive(self, context: ExplorerScriptParser.PrimitiveContext) -> Any: ...
    def visitOperation(self, context: ExplorerScriptParser.OperationContext) -> Any: ...
    def visitInline_ctx(self, context: ExplorerScriptParser.Inline_ctxContext) -> Any: ...
    def visitFunc_suite(self, context: ExplorerScriptParser.Func_suiteContext) -> Any: ...
    def visitFunc_alias(self, context: ExplorerScriptParser.Func_aliasContext) -> Any: ...
    def visitArglist(self, context: ExplorerScriptParser.ArglistContext) -> Any: ...
    def visitPos_argument(self, context: ExplorerScriptParser.Pos_argumentContext) -> Any: ...
    def visitPosition_marker(self, context: ExplorerScriptParser.Position_markerContext) -> Any: ...
    def visitPosition_marker_arg(self, context: ExplorerScriptParser.Position_marker_argContext) -> Any: ...
    def visitLabel(self, context: ExplorerScriptParser.LabelContext) -> Any: ...
    def visitString(self, context: ExplorerScriptParser.StringContext) -> Any: ...
    def visitLang_string(self, context: ExplorerScriptParser.Lang_stringContext) -> Any: ...
    def visitLang_string_argument(self, context: ExplorerScriptParser.Lang_string_argumentContext) -> Any: ...
    def visitString_value(self, context: ExplorerScriptParser.String_valueContext) -> Any: ...
    def visitCtx_header(self, context: ExplorerScriptParser.Ctx_headerContext) -> Any: ...
    def visitFor_target_def_target(self, context: ExplorerScriptParser.For_target_def_targetContext) -> Any: ...
    def visit(self, tree: Antlr4ParseTree) -> Any: ...
    def visitChildren(self, node: Antlr4ParseTree) -> Any: ...
    def defaultResult(self) -> Any: ...
    def aggregateResult(self, aggregate: Any, nextResult: Any) -> Any: ...
    def visitTerminal(self, node: Antlr4ParseTree) -> Any: ...

class ExplorerScriptParserWrapper:
    def __init__(self, string: str, error_listener: Antlr4ErrorListener) -> None: ...
    @property
    def tree(self) -> ExplorerScriptParser.StartContext: ...
    def traverse(self, visitor: ExplorerScriptBaseVisitor) -> Any: ...

class SsbScriptParser:
    class Pos_argumentContext(Antlr4ParserRuleContext):
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def jump_marker(self) -> SsbScriptParser.Jump_markerContext: ...
        def position_marker(self) -> SsbScriptParser.Position_markerContext: ...
        def primitive(self) -> SsbScriptParser.PrimitiveContext: ...

    class Jump_markerContext(Antlr4ParserRuleContext):
        def AT(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class StartContext(Antlr4ParserRuleContext):
        def EOF(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        @overload
        def funcdef(self) -> list[SsbScriptParser.FuncdefContext]: ...
        @overload
        def funcdef(self, i: int) -> SsbScriptParser.FuncdefContext: ...
        def getRuleIndex(self) -> int: ...

    class FuncdefContext(Antlr4ParserRuleContext):
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def coro_def(self) -> SsbScriptParser.Coro_defContext: ...
        def for_target_def(self) -> SsbScriptParser.For_target_defContext: ...
        def getRuleIndex(self) -> int: ...
        def simple_def(self) -> SsbScriptParser.Simple_defContext: ...

    class Simple_defContext(Antlr4ParserRuleContext):
        def DEF(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def func_suite(self) -> SsbScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...

    class Coro_defContext(Antlr4ParserRuleContext):
        def CORO(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def func_suite(self) -> SsbScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...

    class For_target_defContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def DEF(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def for_target_def_target(self) -> SsbScriptParser.For_target_def_targetContext: ...
        def func_suite(self) -> SsbScriptParser.Func_suiteContext: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> SsbScriptParser.PrimitiveContext: ...

    class PrimitiveContext(Antlr4ParserRuleContext):
        def DECIMAL(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def VARIABLE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def string(self) -> SsbScriptParser.StringContext: ...

    class StmtContext(Antlr4ParserRuleContext):
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def label(self) -> SsbScriptParser.LabelContext: ...
        def operation(self) -> SsbScriptParser.OperationContext: ...

    class OperationContext(Antlr4ParserRuleContext):
        def CLOSE_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_PAREN(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def arglist(self) -> SsbScriptParser.ArglistContext: ...
        def getRuleIndex(self) -> int: ...
        def inline_ctx(self) -> SsbScriptParser.Inline_ctxContext: ...

    class Inline_ctxContext(Antlr4ParserRuleContext):
        def CLOSE_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def ctx_header(self) -> SsbScriptParser.Ctx_headerContext: ...
        def getRuleIndex(self) -> int: ...

    class Func_suiteContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def func_alias(self) -> SsbScriptParser.Func_aliasContext: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def stmt(self) -> list[SsbScriptParser.StmtContext]: ...
        @overload
        def stmt(self, i: int) -> SsbScriptParser.StmtContext: ...

    class Func_aliasContext(Antlr4ParserRuleContext):
        def ALIAS(self) -> Antlr4TreeTerminalNode: ...
        def PREVIOUS(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class ArglistContext(Antlr4ParserRuleContext):
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def pos_argument(self) -> list[SsbScriptParser.Pos_argumentContext]: ...
        @overload
        def pos_argument(self, i: int) -> SsbScriptParser.Pos_argumentContext: ...

    class Position_markerContext(Antlr4ParserRuleContext):
        def CLOSE_SHARP(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_SHARP(self) -> Antlr4TreeTerminalNode: ...
        def POSITION(self) -> Antlr4TreeTerminalNode: ...
        def STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def position_marker_arg(self) -> list[SsbScriptParser.Position_marker_argContext]: ...
        @overload
        def position_marker_arg(self, i: int) -> SsbScriptParser.Position_marker_argContext: ...

    class Position_marker_argContext(Antlr4ParserRuleContext):
        def DECIMAL(self) -> Antlr4TreeTerminalNode: ...
        def INTEGER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class LabelContext(Antlr4ParserRuleContext):
        def AT(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def PARAGRAPH(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class StringContext(Antlr4ParserRuleContext):
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def lang_string(self) -> SsbScriptParser.Lang_stringContext: ...
        def string_value(self) -> SsbScriptParser.String_valueContext: ...

    class Lang_stringContext(Antlr4ParserRuleContext):
        def CLOSE_BRACE(self) -> Antlr4TreeTerminalNode: ...
        @overload
        def COMMA(self) -> list[Antlr4TreeTerminalNode]: ...
        @overload
        def COMMA(self, i: int) -> Antlr4TreeTerminalNode: ...
        def OPEN_BRACE(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        @overload
        def lang_string_argument(self) -> list[SsbScriptParser.Lang_string_argumentContext]: ...
        @overload
        def lang_string_argument(self, i: int) -> SsbScriptParser.Lang_string_argumentContext: ...

    class Lang_string_argumentContext(Antlr4ParserRuleContext):
        def ASSIGN(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def string_value(self) -> SsbScriptParser.String_valueContext: ...

    class String_valueContext(Antlr4ParserRuleContext):
        def MULTILINE_STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def STRING_LITERAL(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

    class Ctx_headerContext(Antlr4ParserRuleContext):
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...
        def primitive(self) -> SsbScriptParser.PrimitiveContext: ...

    class For_target_def_targetContext(Antlr4ParserRuleContext):
        def FOR(self) -> Antlr4TreeTerminalNode: ...
        def FOR_TARGET(self) -> Antlr4TreeTerminalNode: ...
        def IDENTIFIER(self) -> Antlr4TreeTerminalNode: ...
        def accept(self, visitor: SsbScriptBaseVisitor) -> Any: ...
        def getRuleIndex(self) -> int: ...

class SsbScriptBaseVisitor:
    def visitPos_argument(self, context: SsbScriptParser.Pos_argumentContext) -> Any: ...
    def visitJump_marker(self, context: SsbScriptParser.Jump_markerContext) -> Any: ...
    def visitStart(self, context: SsbScriptParser.StartContext) -> Any: ...
    def visitFuncdef(self, context: SsbScriptParser.FuncdefContext) -> Any: ...
    def visitSimple_def(self, context: SsbScriptParser.Simple_defContext) -> Any: ...
    def visitCoro_def(self, context: SsbScriptParser.Coro_defContext) -> Any: ...
    def visitFor_target_def(self, context: SsbScriptParser.For_target_defContext) -> Any: ...
    def visitPrimitive(self, context: SsbScriptParser.PrimitiveContext) -> Any: ...
    def visitStmt(self, context: SsbScriptParser.StmtContext) -> Any: ...
    def visitOperation(self, context: SsbScriptParser.OperationContext) -> Any: ...
    def visitInline_ctx(self, context: SsbScriptParser.Inline_ctxContext) -> Any: ...
    def visitFunc_suite(self, context: SsbScriptParser.Func_suiteContext) -> Any: ...
    def visitFunc_alias(self, context: SsbScriptParser.Func_aliasContext) -> Any: ...
    def visitArglist(self, context: SsbScriptParser.ArglistContext) -> Any: ...
    def visitPosition_marker(self, context: SsbScriptParser.Position_markerContext) -> Any: ...
    def visitPosition_marker_arg(self, context: SsbScriptParser.Position_marker_argContext) -> Any: ...
    def visitLabel(self, context: SsbScriptParser.LabelContext) -> Any: ...
    def visitString(self, context: SsbScriptParser.StringContext) -> Any: ...
    def visitLang_string(self, context: SsbScriptParser.Lang_stringContext) -> Any: ...
    def visitLang_string_argument(self, context: SsbScriptParser.Lang_string_argumentContext) -> Any: ...
    def visitString_value(self, context: SsbScriptParser.String_valueContext) -> Any: ...
    def visitCtx_header(self, context: SsbScriptParser.Ctx_headerContext) -> Any: ...
    def visitFor_target_def_target(self, context: SsbScriptParser.For_target_def_targetContext) -> Any: ...
    def visit(self, tree: Antlr4ParseTree) -> Any: ...
    def visitChildren(self, node: Antlr4ParseTree) -> Any: ...
    def defaultResult(self) -> Any: ...
    def aggregateResult(self, aggregate: Any, nextResult: Any) -> Any: ...
    def visitTerminal(self, node: Antlr4ParseTree) -> Any: ...

class SsbScriptParserWrapper:
    def __init__(self, string: str, error_listener: Antlr4ErrorListener) -> None: ...
    @property
    def tree(self) -> SsbScriptParser.StartContext: ...
    def traverse(self, visitor: SsbScriptBaseVisitor) -> Any: ...
