# FAAS-SDK для тестирования и локальной отладки Python функций

FAAS-SDK позволяет локально тестировать функции [Platform V Functions](https://developers.sber.ru/portal/products/platform-v-functions) без необходимости писать HTTP сервер и логику обработки запросов.

SDK для Python устанавливается как обычный пакет.

## Пререквизиты

* Python 3.8.x;
* pip 19.3.x;

## Установка и использование

1. Перейдите в директорию проекта с функцией в CLI. Если вы только начинаете локальную разработку, вы можете:
   * Экспортировать функцию из Functions и распаковать архив в произвольную локальную директорию.
   * Начать работу с чистого проекта - для этого создайте в произвольной локальной директории файл `handlers/handler.py` содержаший:

    ```python
    def handler(request):
        return "Hello from Python function"
    ```

    > Функция должна принимать один параметер `(request)`  -  Flask [`Request`](http://flask.pocoo.org/docs/1.0/api/#flask.Request) object.

2. Установите SDK:

    ```shell
    pip install faas-sdk-python
    ```

3. Запустите функцию следующей командой:

    ```shell
    faas-sdk-python --target handler --source handlers/handler.py
    ```

4. Отправьте запрос используя `curl`, браузер или другие инструменты:

    ```shell
    curl localhost:8080
    # Hello from Python function
    ```

## Конфигурация {uniqueId="konfiguratsiya5"}

Запуск SDK конфигурируется с помощью флагов командной строки или переменных среды:

| Флаг        | Переменная среды  | Значение по умолчанию | Описание                                                                              |
| ------------| ------------------|-----------------------| --------------------------------------------------------------------------------------|
| `--host`    | `HOST`            | 0.0.0.0               | Хост, на котором будет работать слушатель запросов                                    |
| `--port`    | `PORT`            | 8080                  | Порт, на котором будет работать слушатель запросов                                    |
| `--target`  | `TARGET`          | (отсутствует)         | Имя функции, которая будет вызываться в ответ на запросы. Обязательный параметр       |
| `--source`  | `SOURCE`          | ./handler.py          | Путь к файлу, содержащему функцию                                                     |
| `--dry-run` | `DRY_RUN`         | false                 | Флаг, позволяющий тестировать сборку функции без запуска сервера                      |

Если один и тот же парметр задан и через флаги, и через переменную среды, то значение переменной среды будет игнорироваться.

## Unit-тестирование

Вы можете добавить unit-тесты в тестируемую локально функцию так же, как и в любой Python проект.

Например, для тестирования `hello, world` примера:

1. Создайте в директории `handlers` файл handler_test.py` со следующим содержанием:
    
    ```python
    from unittest.mock import Mock
    import handler

    def test_hello():
        request = Mock(data=Mock(decode=Mock(return_value="")), method="GET")
        assert handler.hello(request)=="Hello from Python function"
    ```

2. Перейдите в директорию проекта в CLI и запустите тест командой `pytest`. Результаты теста будут отображены в терминале.

