# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from fabric_protos_python.gateway import gateway_pb2 as gateway_dot_gateway__pb2


class GatewayStub(object):
    """The Gateway API for evaluating and submitting transactions via the gateway.
    Transaction evaluation (query) requires the invocation of the Evaluate service
    Transaction submission (ledger updates) is a two step process invoking Endorse
    followed by Submit. A third step, invoking CommitStatus, is required if the
    clients wish to wait for a Transaction to be committed.
    The proposal and transaction must be signed by the client before each step.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Endorse = channel.unary_unary(
                '/gateway.Gateway/Endorse',
                request_serializer=gateway_dot_gateway__pb2.EndorseRequest.SerializeToString,
                response_deserializer=gateway_dot_gateway__pb2.EndorseResponse.FromString,
                )
        self.Submit = channel.unary_unary(
                '/gateway.Gateway/Submit',
                request_serializer=gateway_dot_gateway__pb2.SubmitRequest.SerializeToString,
                response_deserializer=gateway_dot_gateway__pb2.SubmitResponse.FromString,
                )
        self.CommitStatus = channel.unary_unary(
                '/gateway.Gateway/CommitStatus',
                request_serializer=gateway_dot_gateway__pb2.SignedCommitStatusRequest.SerializeToString,
                response_deserializer=gateway_dot_gateway__pb2.CommitStatusResponse.FromString,
                )
        self.Evaluate = channel.unary_unary(
                '/gateway.Gateway/Evaluate',
                request_serializer=gateway_dot_gateway__pb2.EvaluateRequest.SerializeToString,
                response_deserializer=gateway_dot_gateway__pb2.EvaluateResponse.FromString,
                )
        self.ChaincodeEvents = channel.unary_stream(
                '/gateway.Gateway/ChaincodeEvents',
                request_serializer=gateway_dot_gateway__pb2.SignedChaincodeEventsRequest.SerializeToString,
                response_deserializer=gateway_dot_gateway__pb2.ChaincodeEventsResponse.FromString,
                )


class GatewayServicer(object):
    """The Gateway API for evaluating and submitting transactions via the gateway.
    Transaction evaluation (query) requires the invocation of the Evaluate service
    Transaction submission (ledger updates) is a two step process invoking Endorse
    followed by Submit. A third step, invoking CommitStatus, is required if the
    clients wish to wait for a Transaction to be committed.
    The proposal and transaction must be signed by the client before each step.
    """

    def Endorse(self, request, context):
        """The Endorse service passes a proposed transaction to the gateway in order to
        obtain sufficient endorsement.
        The gateway will determine the endorsement plan for the requested chaincode and
        forward to the appropriate peers for endorsement. It will return to the client a
        prepared transaction in the form of an Envelope message as defined
        in common/common.proto. The client must sign the contents of this envelope
        before invoking the Submit service.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Submit(self, request, context):
        """The Submit service will process the prepared transaction returned from Endorse service
        once it has been signed by the client. It will wait for the transaction to be submitted to the
        ordering service but the client must invoke the CommitStatus service to wait for the transaction
        to be committed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CommitStatus(self, request, context):
        """The CommitStatus service will indicate whether a prepared transaction previously submitted to
        the Submit sevice has been committed. It will wait for the commit to occur if it hasn’t already
        committed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Evaluate(self, request, context):
        """The Evaluate service passes a proposed transaction to the gateway in order to invoke the
        transaction function and return the result to the client. No ledger updates are made.
        The gateway will select an appropriate peer to query based on block height and load.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ChaincodeEvents(self, request, context):
        """The ChaincodeEvents service supplies a stream of responses, each containing all the events emitted by the
        requested chaincode for a specific block. The streamed responses are ordered by ascending block number. Responses
        are only returned for blocks that contain the requested events, while blocks not containing any of the requested
        events are skipped.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_GatewayServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Endorse': grpc.unary_unary_rpc_method_handler(
                    servicer.Endorse,
                    request_deserializer=gateway_dot_gateway__pb2.EndorseRequest.FromString,
                    response_serializer=gateway_dot_gateway__pb2.EndorseResponse.SerializeToString,
            ),
            'Submit': grpc.unary_unary_rpc_method_handler(
                    servicer.Submit,
                    request_deserializer=gateway_dot_gateway__pb2.SubmitRequest.FromString,
                    response_serializer=gateway_dot_gateway__pb2.SubmitResponse.SerializeToString,
            ),
            'CommitStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.CommitStatus,
                    request_deserializer=gateway_dot_gateway__pb2.SignedCommitStatusRequest.FromString,
                    response_serializer=gateway_dot_gateway__pb2.CommitStatusResponse.SerializeToString,
            ),
            'Evaluate': grpc.unary_unary_rpc_method_handler(
                    servicer.Evaluate,
                    request_deserializer=gateway_dot_gateway__pb2.EvaluateRequest.FromString,
                    response_serializer=gateway_dot_gateway__pb2.EvaluateResponse.SerializeToString,
            ),
            'ChaincodeEvents': grpc.unary_stream_rpc_method_handler(
                    servicer.ChaincodeEvents,
                    request_deserializer=gateway_dot_gateway__pb2.SignedChaincodeEventsRequest.FromString,
                    response_serializer=gateway_dot_gateway__pb2.ChaincodeEventsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.Gateway', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Gateway(object):
    """The Gateway API for evaluating and submitting transactions via the gateway.
    Transaction evaluation (query) requires the invocation of the Evaluate service
    Transaction submission (ledger updates) is a two step process invoking Endorse
    followed by Submit. A third step, invoking CommitStatus, is required if the
    clients wish to wait for a Transaction to be committed.
    The proposal and transaction must be signed by the client before each step.
    """

    @staticmethod
    def Endorse(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/gateway.Gateway/Endorse',
            gateway_dot_gateway__pb2.EndorseRequest.SerializeToString,
            gateway_dot_gateway__pb2.EndorseResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Submit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/gateway.Gateway/Submit',
            gateway_dot_gateway__pb2.SubmitRequest.SerializeToString,
            gateway_dot_gateway__pb2.SubmitResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CommitStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/gateway.Gateway/CommitStatus',
            gateway_dot_gateway__pb2.SignedCommitStatusRequest.SerializeToString,
            gateway_dot_gateway__pb2.CommitStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Evaluate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/gateway.Gateway/Evaluate',
            gateway_dot_gateway__pb2.EvaluateRequest.SerializeToString,
            gateway_dot_gateway__pb2.EvaluateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ChaincodeEvents(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/gateway.Gateway/ChaincodeEvents',
            gateway_dot_gateway__pb2.SignedChaincodeEventsRequest.SerializeToString,
            gateway_dot_gateway__pb2.ChaincodeEventsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
