# Generated by ariadne-codegen
# Source: fanpoints_python/queries

from typing import Any, Dict, List, Optional, Union

from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .does_user_exist import DoesUserExist
from .enums import Currency
from .estimate_given_out_fan_points_on_purchase import (
    EstimateGivenOutFanPointsOnPurchase,
)
from .get_fan_points_transaction import GetFanPointsTransaction
from .get_fan_points_transactions import GetFanPointsTransactions
from .get_price_in_fan_points import GetPriceInFanPoints
from .give_fan_points_on_purchase import GiveFanPointsOnPurchase
from .input_types import PurchaseItemInput, PurchaseItemPriceInput
from .pay_purchase_with_fan_points import PayPurchaseWithFanPoints
from .ping import Ping
from .undo_fan_points_purchase import UndoFanPointsPurchase


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def does_user_exist(
        self, partner_id: str, user_id: str, **kwargs: Any
    ) -> DoesUserExist:
        query = gql(
            """
            query does_user_exist($partner_id: String!, $user_id: String!) {
              does_user_exist(partner_id: $partner_id, user_id: $user_id) {
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {"partner_id": partner_id, "user_id": user_id}
        response = await self.execute(
            query=query, operation_name="does_user_exist", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DoesUserExist.model_validate(data)

    async def estimate_given_out_fan_points_on_purchase(
        self,
        partner_id: str,
        purchase_items: List[PurchaseItemPriceInput],
        **kwargs: Any,
    ) -> EstimateGivenOutFanPointsOnPurchase:
        query = gql(
            """
            query estimateGivenOutFanPointsOnPurchase($partnerId: String!, $purchaseItems: [PurchaseItemPriceInput!]!) {
              estimateGivenOutFanPointsOnPurchase: estimate_given_out_fan_points_on_purchase(
                partner_id: $partnerId
                purchase_items: $purchaseItems
              ) {
                errors {
                  invalidRateLabelError: invalid_rate_label_error {
                    _empty
                  }
                }
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "partnerId": partner_id,
            "purchaseItems": purchase_items,
        }
        response = await self.execute(
            query=query,
            operation_name="estimateGivenOutFanPointsOnPurchase",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return EstimateGivenOutFanPointsOnPurchase.model_validate(data)

    async def get_fan_points_transaction(
        self, user_id: str, purchase_id: str, partner_id: str, **kwargs: Any
    ) -> GetFanPointsTransaction:
        query = gql(
            """
            query getFanPointsTransaction($userId: String!, $purchaseId: String!, $partnerId: String!) {
              getFanPointsTransaction: get_fan_points_transaction(
                user_id: $userId
                purchase_id: $purchaseId
                partner_id: $partnerId
              ) {
                result {
                  purchaseId: purchase_id
                  userId: user_id
                  transactionType: transaction_type
                  purchaseItems: purchase_items {
                    purchaseItemId: purchase_item_id
                    partnerId: partner_id
                    title
                    description
                    price
                    currency
                    amount
                    rateLabel: rate_label
                    date
                    hasBeenUndone: has_been_undone
                    hasBeenSettled: has_been_settled
                  }
                }
                errors {
                  unknownUserError: unknown_user_error {
                    _empty
                  }
                  transactionNotFoundError: transaction_not_found_error {
                    _empty
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "userId": user_id,
            "purchaseId": purchase_id,
            "partnerId": partner_id,
        }
        response = await self.execute(
            query=query,
            operation_name="getFanPointsTransaction",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return GetFanPointsTransaction.model_validate(data)

    async def get_fan_points_transactions(
        self,
        partner_id: str,
        user_id: str,
        limit: Union[Optional[int], UnsetType] = UNSET,
        earlier_than: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any,
    ) -> GetFanPointsTransactions:
        query = gql(
            """
            query getFanPointsTransactions($partnerId: String!, $userId: String!, $limit: Int, $earlierThan: String) {
              getFanPointsTransactions: get_partner_fan_points_transactions(
                partner_id: $partnerId
                user_id: $userId
                earlier_than: $earlierThan
                limit: $limit
              ) {
                result {
                  purchaseId: purchase_id
                  userId: user_id
                  transactionType: transaction_type
                  purchaseItems: purchase_items {
                    purchaseItemId: purchase_item_id
                    partnerId: partner_id
                    title
                    description
                    price
                    currency
                    amount
                    rateLabel: rate_label
                    date
                    hasBeenUndone: has_been_undone
                    hasBeenSettled: has_been_settled
                  }
                }
                errors {
                  unknownUserError: unknown_user_error {
                    _empty
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "partnerId": partner_id,
            "userId": user_id,
            "limit": limit,
            "earlierThan": earlier_than,
        }
        response = await self.execute(
            query=query,
            operation_name="getFanPointsTransactions",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return GetFanPointsTransactions.model_validate(data)

    async def get_price_in_fan_points(
        self, partner_id: str, price: float, currency: Currency, **kwargs: Any
    ) -> GetPriceInFanPoints:
        query = gql(
            """
            query getPriceInFanPoints($partnerId: String!, $price: Float!, $currency: Currency!) {
              getPriceInFanPoints: get_price_in_fan_points(
                partner_id: $partnerId
                price: $price
                currency: $currency
              ) {
                errors {
                  InvalidRewardAmountError: invalid_reward_amount_error {
                    _empty
                  }
                }
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "partnerId": partner_id,
            "price": price,
            "currency": currency,
        }
        response = await self.execute(
            query=query,
            operation_name="getPriceInFanPoints",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return GetPriceInFanPoints.model_validate(data)

    async def give_fan_points_on_purchase(
        self,
        user_id: str,
        partner_id: str,
        purchase_items: List[PurchaseItemInput],
        custom_purchase_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any,
    ) -> GiveFanPointsOnPurchase:
        query = gql(
            """
            mutation giveFanPointsOnPurchase($userId: String!, $partnerId: String!, $purchaseItems: [PurchaseItemInput!]!, $customPurchaseId: String) {
              giveFanPointsOnPurchase: give_fan_points_on_purchase(
                user_id: $userId
                partner_id: $partnerId
                purchase_items: $purchaseItems
                custom_purchase_id: $customPurchaseId
              ) {
                errors {
                  unknownUserError: unknown_user_error {
                    _empty
                  }
                  invalidRewardAmountError: invalid_reward_amount_error {
                    _empty
                  }
                  tooFewAvailableError: too_few_available_error {
                    _empty
                  }
                  invalidTransactionIdError: invalid_transaction_id_error {
                    _empty
                  }
                  invalidRateLabelError: invalid_rate_label_error {
                    _empty
                  }
                  alreadyExecutedError: already_executed_error {
                    _empty
                  }
                  nonUniquePurchaseItemIdsError: non_unique_purchase_item_ids_error {
                    _empty
                  }
                }
                result {
                  purchaseId: purchase_id
                  userId: user_id
                  transactionType: transaction_type
                  purchaseItems: purchase_items {
                    purchaseItemId: purchase_item_id
                    partnerId: partner_id
                    title
                    description
                    price
                    currency
                    amount
                    rateLabel: rate_label
                    date
                    hasBeenUndone: has_been_undone
                    hasBeenSettled: has_been_settled
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "userId": user_id,
            "partnerId": partner_id,
            "purchaseItems": purchase_items,
            "customPurchaseId": custom_purchase_id,
        }
        response = await self.execute(
            query=query,
            operation_name="giveFanPointsOnPurchase",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return GiveFanPointsOnPurchase.model_validate(data)

    async def pay_purchase_with_fan_points(
        self,
        user_id: str,
        partner_id: str,
        purchase_items: List[PurchaseItemInput],
        custom_purchase_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any,
    ) -> PayPurchaseWithFanPoints:
        query = gql(
            """
            mutation payPurchaseWithFanPoints($userId: String!, $partnerId: String!, $purchaseItems: [PurchaseItemInput!]!, $customPurchaseId: String) {
              payPurchaseWithFanPoints: pay_purchase_with_fan_points(
                user_id: $userId
                partner_id: $partnerId
                purchase_items: $purchaseItems
                custom_purchase_id: $customPurchaseId
              ) {
                errors {
                  unknownUserError: unknown_user_error {
                    _empty
                  }
                  invalidRewardAmountError: invalid_reward_amount_error {
                    _empty
                  }
                  tooFewAvailableError: too_few_available_error {
                    _empty
                  }
                  invalidTransactionIdError: invalid_transaction_id_error {
                    _empty
                  }
                  invalidRateLabelError: invalid_rate_label_error {
                    _empty
                  }
                  alreadyExecutedError: already_executed_error {
                    _empty
                  }
                  nonUniquePurchaseItemIdsError: non_unique_purchase_item_ids_error {
                    _empty
                  }
                }
                result {
                  purchaseId: purchase_id
                  userId: user_id
                  transactionType: transaction_type
                  purchaseItems: purchase_items {
                    purchaseItemId: purchase_item_id
                    partnerId: partner_id
                    title
                    description
                    price
                    currency
                    amount
                    rateLabel: rate_label
                    date
                    hasBeenUndone: has_been_undone
                    hasBeenSettled: has_been_settled
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "userId": user_id,
            "partnerId": partner_id,
            "purchaseItems": purchase_items,
            "customPurchaseId": custom_purchase_id,
        }
        response = await self.execute(
            query=query,
            operation_name="payPurchaseWithFanPoints",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return PayPurchaseWithFanPoints.model_validate(data)

    async def ping(self, **kwargs: Any) -> Ping:
        query = gql(
            """
            query ping {
              ping
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="ping", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Ping.model_validate(data)

    async def undo_fan_points_purchase(
        self,
        user_id: str,
        partner_id: str,
        purchase_id: str,
        purchase_item_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any,
    ) -> UndoFanPointsPurchase:
        query = gql(
            """
            mutation undoFanPointsPurchase($userId: String!, $partnerId: String!, $purchaseId: String!, $purchaseItemId: String) {
              undoFanPointsPurchase: undo_fan_points_transaction(
                user_id: $userId
                partner_id: $partnerId
                purchase_id: $purchaseId
                purchase_item_id: $purchaseItemId
              ) {
                result {
                  purchaseId: purchase_id
                  userId: user_id
                  transactionType: transaction_type
                  purchaseItems: purchase_items {
                    purchaseItemId: purchase_item_id
                    partnerId: partner_id
                    title
                    description
                    price
                    currency
                    amount
                    rateLabel: rate_label
                    date
                    hasBeenUndone: has_been_undone
                    hasBeenSettled: has_been_settled
                  }
                }
                errors {
                  unknownUserError: unknown_user_error {
                    _empty
                  }
                  invalidRewardAmountError: invalid_reward_amount_error {
                    _empty
                  }
                  tooFewAvailableError: too_few_available_error {
                    _empty
                  }
                  transactionNotFoundError: transaction_not_found_error {
                    _empty
                  }
                  invalidTransactionIdError: invalid_transaction_id_error {
                    _empty
                  }
                  alreadyExecutedError: already_executed_error {
                    _empty
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "userId": user_id,
            "partnerId": partner_id,
            "purchaseId": purchase_id,
            "purchaseItemId": purchase_item_id,
        }
        response = await self.execute(
            query=query,
            operation_name="undoFanPointsPurchase",
            variables=variables,
            **kwargs,
        )
        data = self.get_data(response)
        return UndoFanPointsPurchase.model_validate(data)
