# Design: FastAPI CLI Tool

## Context

Hono CLIの`hono request`コマンドを参考に、FastAPIアプリケーションに対してサーバーを立ち上げずにリクエストを送信できるCLIツールを開発します。FastAPIはASGIベースのフレームワークであり、TestClientを使用することでサーバーを起動せずにリクエストを処理できます。

## Goals / Non-Goals

### Goals
- FastAPIアプリケーションに対してサーバーを立ち上げずにリクエストを送信
- curlライクなコマンドラインインターフェース
- JSONレスポンスの読みやすい表示
- PyPIに公開可能なパッケージ構造
- AIコーディングエージェントが使用しやすい標準出力ベースの設計

### Non-Goals
- サーバーの起動機能（`fapi-cli serve`のような機能は含めない）
- ドキュメント生成機能（`hono docs`相当は含めない）
- アプリケーションの最適化機能（`hono optimize`相当は含めない）
- 複数のFastAPIアプリケーションの管理機能

## Decisions

### Decision: FastAPI TestClientを使用
**理由**: FastAPIは標準で`TestClient`を提供しており、ASGIアプリケーションに対してサーバーを起動せずにリクエストを送信できます。これはHonoの`app.request()`と同等の機能です。

**代替案**: 
- HTTPサーバーを起動してリクエストを送信する方法（開発フローが煩雑）
- 直接ASGIアプリケーションを呼び出す方法（TestClientが既に実装済み）

### Decision: ClickまたはTyperをCLIフレームワークとして使用
**理由**: Pythonの標準的なCLIフレームワークであり、型ヒントのサポートや使いやすさが優れています。TyperはFastAPIと同じ作者（Sebastian Ramirez）が開発しており、FastAPIプロジェクトとの親和性が高いです。

**代替案**:
- `argparse`（標準ライブラリだが、コードが冗長）
- `click`（成熟したライブラリ、広く使用されている）

### Decision: デフォルトファイルパスは`src/main.py`または`main.py`
**理由**: FastAPIアプリケーションの一般的な構造に合わせます。Hono CLIの`src/index.ts`と同様のパターンです。

**代替案**:
- カレントディレクトリの`app.py`をデフォルトにする
- 設定ファイルでデフォルトパスを指定可能にする（将来的な拡張）

### Decision: レスポンスはJSONフォーマットで標準出力に出力
**理由**: AIコーディングエージェントが読み取りやすく、パイプ処理も可能です。Hono CLIと同様の設計思想です。

**代替案**:
- テーブル形式での表示（人間にとって読みやすいが、AIには不向き）
- カスタマイズ可能な出力フォーマット（将来的な拡張）

## Risks / Trade-offs

### Risk: FastAPIアプリケーションの読み込み方法
**リスク**: ユーザーが指定したファイルからFastAPIアプリケーション（`app`オブジェクト）を正しく読み込めない可能性があります。

**対策**: 
- 明確なエラーメッセージを提供
- 一般的なパターン（`app`、`application`、`fastapi_app`など）をサポート
- ドキュメントに使用例を記載

### Risk: 依存関係の管理
**リスク**: FastAPIアプリケーションが特定の依存関係を必要とする場合、CLIツールがそれらを解決できない可能性があります。

**対策**:
- ユーザーの環境で実行されるため、アプリケーションの依存関係はユーザーが管理
- エラーメッセージで依存関係の問題を明確に示す

### Trade-off: 機能の範囲
**判断**: 最初のバージョンでは`fapi-cli request`コマンドのみを実装し、他の機能（`serve`、`docs`など）は含めません。

**理由**: 最小限の機能で価値を提供し、ユーザーフィードバックに基づいて機能を拡張します。

## Migration Plan

新規プロジェクトのため、マイグレーションは不要です。

## Open Questions

- [x] CLIツールの名前は`fapi-cli`に決定（他のツールとの衝突を避けるため）
- [ ] 複数のFastAPIアプリケーションを同時にテストする機能は必要か？
- [ ] 設定ファイル（`.fapirc`など）でデフォルト値を設定する機能は必要か？

