## 1. プロジェクト基盤の構築

- [x] 1.1 プロジェクト構造の作成（`src/fapi_cli/`ディレクトリ）
- [x] 1.2 `pyproject.toml`の作成（パッケージメタデータ、依存関係）
- [x] 1.3 `README.md`の作成（使用方法、インストール手順）
- [x] 1.4 `.gitignore`の設定

## 2. CLIコア機能の実装

- [x] 2.1 CLIエントリーポイントの実装（`fapi-cli`コマンド）
- [x] 2.2 FastAPIアプリケーションの読み込み機能（指定ファイルから`app`をインポート）
- [x] 2.3 TestClientを使用したリクエスト送信機能
- [x] 2.4 レスポンスのJSONフォーマット化と標準出力への出力

## 3. `fapi-cli request`コマンドの実装

- [x] 3.1 基本リクエスト機能（GETリクエスト、デフォルトパス`/`）
- [x] 3.2 HTTPメソッド指定オプション（`-X`/`--method`）
- [x] 3.3 パス指定オプション（`-P`/`--path`）
- [x] 3.4 リクエストボディ指定オプション（`-d`/`--data`）
- [x] 3.5 ヘッダー指定オプション（`-H`/`--header`）
- [x] 3.6 クエリパラメータ指定オプション（`-q`/`--query`）

## 4. エラーハンドリング

- [x] 4.1 ファイルが見つからない場合のエラーハンドリング
- [x] 4.2 FastAPIアプリケーションの読み込み失敗時のエラーハンドリング
- [x] 4.3 リクエスト送信時のエラーハンドリング（404、500など）
- [x] 4.4 不正なJSONボディの検証

## 5. 出力フォーマット

- [x] 5.1 レスポンスステータスコードの表示
- [x] 5.2 レスポンスヘッダーの表示（オプション）
- [x] 5.3 レスポンスボディのJSON整形表示
- [x] 5.4 エラーレスポンスの適切な表示

## 6. テスト

- [x] 6.1 単体テストの作成（各機能のテスト）
- [x] 6.2 統合テストの作成（サンプルFastAPIアプリとの統合テスト）
- [x] 6.3 エラーケースのテスト
- [x] 6.4 テストカバレッジの確認

## 7. パッケージングと公開準備

- [x] 7.1 `pyproject.toml`の最終調整（バージョン、依存関係）
- [x] 7.2 ビルド設定の確認（`build`パッケージ）
- [x] 7.3 PyPI公開用の設定（`twine`設定）
- [x] 7.4 ライセンスファイルの追加
- [x] 7.5 ドキュメントの整備（使用例、APIリファレンス）

## 8. 検証

- [x] 8.1 ローカルでの動作確認
- [x] 8.2 様々なFastAPIアプリケーションでの動作確認
- [x] 8.3 PyPIへのテストアップロード（TestPyPI）
- [x] 8.4 インストールと実行の確認

