# SPDX-License-Identifier: MPL-2.0
from types import EllipsisType
from typing import Any, Literal, Self, overload

import numpy as np
from cupy.cuda import Stream
from numpy._core.multiarray import flagsobj
from numpy.typing import NDArray

class ndarray:
    dtype: np.dtype[Any]
    shape: tuple[int, ...]
    size: int
    ndim: int
    flags: flagsobj

    # cupy-specific
    def get(
        self, stream: Stream | None = None, order: Literal["C", "F", "A"] = "C", out: NDArray[Any] | None = None, blocking: bool = True
    ) -> NDArray[Any]: ...

    # operators
    def __array__(self) -> NDArray[Any]: ...
    def __len__(self) -> int: ...
    def __getitem__(  # never returns scalars
        self, index: int | slice | EllipsisType | tuple[int | slice | EllipsisType | None, ...]
    ) -> Self: ...
    def __eq__(self, value: object) -> ndarray: ...  # type: ignore[override]
    def __power__(self, other: int) -> Self: ...

    # methods
    @property
    def T(self) -> Self: ...  # noqa: N802
    @overload
    def all(self, axis: None = None) -> np.bool: ...
    @overload
    def all(self, axis: int) -> ndarray: ...
    def reshape(self, shape: tuple[int, ...] | int) -> ndarray: ...
    def squeeze(self, axis: int | None = None) -> Self: ...
    def ravel(self, order: Literal["C", "F", "A", "K"] = "C") -> Self: ...
    def flatten(self, order: Literal["C", "F", "A", "K"] = "C") -> Self: ...
    @property
    def flat(self) -> _FlatIter: ...

class _FlatIter:
    def __next__(self) -> np.float32 | np.float64: ...
    def __iter__(self) -> _FlatIter: ...
    def __len__(self) -> int: ...
    def __getitem__(self, index: int) -> np.float32 | np.float64: ...
