# SPDX-License-Identifier: MPL-2.0
# See <https://numba.readthedocs.io/en/stable/reference/types.html#numba-types>

from typing import Literal, Self, TypeAlias

from numba.core.typing.templates import Signature

class Type:
    def __init__(self, name: str) -> None: ...
    def __call__(self, *args: object, **kwds: object) -> Signature: ...

class boolean(Type): ...
class uint8(Type): ...

byte = uint8

class uint16(Type): ...
class uint32(Type): ...
class uint64(Type): ...
class int8(Type): ...

char = int8

class int16(Type): ...
class int32(Type): ...
class int64(Type): ...
class intc(Type): ...
class uintc(Type): ...
class intp(Type): ...
class uintp(Type): ...
class ssize_t(Type): ...
class size_t(Type): ...
class float32(Type): ...
class float64(Type): ...

double = float64

class complex64(Type): ...
class complex128(Type): ...

# composite
class IterableType(Type): ...
class Sized(Type): ...

class ArrayCompatible(Type):
    ndim: int
    layout: Buffer.Layout
    dtype: Type

class Buffer(IterableType, ArrayCompatible):
    Layout: TypeAlias = Literal["C", "F", "CS", "FS", "A"]
    LAYOUTS: frozenset[Layout]
    def copy(
        self,
        dtype: Type | type[Type] | None = None,
        ndim: int | None = None,
        layout: Layout | None = None,
    ) -> Self: ...

class Array(Buffer):
    def __init__(
        self,
        dtype: Type | type[Type],
        ndim: int,
        layout: Buffer.Layout,
        readonly: bool = False,
        name: str | None = None,
        aligned: bool = True,
    ) -> None: ...

class Dummy(Type): ...
class Opaque(Dummy): ...
class DTypeSpec(Type): ...

class DType(DTypeSpec, Opaque):
    def __init__(self, dtype: Type) -> None: ...

class ConstSized(Sized):
    def __len__(self) -> int: ...

class Hashable(Type): ...
class BaseTuple(ConstSized, Hashable): ...
class BaseAnonymousTuple(BaseTuple): ...
class Container(Sized, IterableType): ...
class Sequence(Container): ...

class UniTuple(BaseAnonymousTuple, Sequence):
    def __init__(self, dtype: Type | type[Type], count: int) -> None: ...
