# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_code_generator']

package_data = \
{'': ['*'], 'fastapi_code_generator': ['template/*']}

install_requires = \
['PySnooper>=0.4.1,<0.5.0',
 'black>=19.10b0,<20.0',
 'datamodel-code-generator>=0.5.5,<0.6.0',
 'isort>=4.3.21,<5.0.0',
 'jinja2>=2.11.2,<3.0.0',
 'pydantic>=1.5.1,<2.0.0',
 'stringcase>=1.2.0,<2.0.0',
 'typer[all]>=0.2.1,<0.3.0']

entry_points = \
{'console_scripts': ['fastapi-codegen = fastapi_code_generator.__main__:app']}

setup_kwargs = {
    'name': 'fastapi-code-generator',
    'version': '0.0.1',
    'description': '',
    'long_description': '# fastapi-code-generator\n\nThis code generator creates FastAPI app from an openapi file.\n\n[![PyPI version](https://badge.fury.io/py/fastapi-code-generator.svg)](https://pypi.python.org/pypi/fastapi-code-generator)\n[![Downloads](https://pepy.tech/badge/fastapi-code-generator/month)](https://pepy.tech/project/fastapi-code-generator/month)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/fastapi-code-generator)](https://pypi.python.org/pypi/fastapi-code-generator)\n[![codecov](https://codecov.io/gh/koxudaxi/fastapi-code-generator/branch/master/graph/badge.svg)](https://codecov.io/gh/koxudaxi/fastapi-code-generator)\n![license](https://img.shields.io/github/license/koxudaxi/fastapi-code-generator.svg)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\n## This project is an experimental phase.\n\nfastapi-code-generator uses [datamodel-code-generator](https://github.com/koxudaxi/datamodel-code-generator) to generate pydantic models\n\n## Help\nSee [documentation](https://koxudaxi.github.io/fastapi-code-generator) for more details.\n\n\n## Installation\n\nTo install `fastapi-code-generator`:\n```sh\n$ pip install fastapi-code-generator\n```\n\n## Usage\n\nThe `fastapi-code-generator` command:\n```\nUsage: fastapi-codegen [OPTIONS]\n\nOptions:\n  -i, --input FILENAME     [required]\n  -o, --output PATH        [required]\n  -t, --template-dir PATH\n  --install-completion     Install completion for the current shell.\n  --show-completion        Show completion for the current shell, to copy it\n                           or customize the installation.\n\n  --help                   Show this message and exit.\n```\n\n## Example\n### OpenAPI\n```sh\n$ fastapi-codegen --input api.yaml --output app\n```\n\n<details>\n<summary>api.yaml</summary>\n<pre>\n<code>\n```yaml\nopenapi: "3.0.0"\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\n  license:\n    name: MIT\nservers:\n  - url: http://petstore.swagger.io/v1\npaths:\n  /pets:\n    get:\n      summary: List all pets\n      operationId: listPets\n      tags:\n        - pets\n      parameters:\n        - name: limit\n          in: query\n          description: How many items to return at one time (max 100)\n          required: false\n          schema:\n            type: integer\n            format: int32\n      responses:\n        \'200\':\n          description: A paged array of pets\n          headers:\n            x-next:\n              description: A link to the next page of responses\n              schema:\n                type: string\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n    post:\n      summary: Create a pet\n      operationId: createPets\n      tags:\n        - pets\n      responses:\n        \'201\':\n          description: Null response\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n  /pets/{petId}:\n    get:\n      summary: Info for a specific pet\n      operationId: showPetById\n      tags:\n        - pets\n      parameters:\n        - name: petId\n          in: path\n          required: true\n          description: The id of the pet to retrieve\n          schema:\n            type: string\n      responses:\n        \'200\':\n          description: Expected response to a valid request\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n    x-amazon-apigateway-integration:\n      uri:\n        Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n      passthroughBehavior: when_no_templates\n      httpMethod: POST\n      type: aws_proxy\ncomponents:\n  schemas:\n    Pet:\n      required:\n        - id\n        - name\n      properties:\n        id:\n          type: integer\n          format: int64\n        name:\n          type: string\n        tag:\n          type: string\n    Pets:\n      type: array\n      items:\n        $ref: "#/components/schemas/Pet"\n    Error:\n      required:\n        - code\n        - message\n      properties:\n        code:\n          type: integer\n          format: int32\n        message:\n          type: string\n```\n</code>\n</pre>\n</details>\n\n\n`app/main.py`:\n```python\n# generated by fastapi-codegen:\n#   filename:  api.yaml\n#   timestamp: 2020-06-14T10:45:22+00:00\n\nfrom __future__ import annotations\n\nfrom typing import Optional\n\nfrom fastapi import FastAPI\n\nfrom .models import Pet, Pets\n\napp = FastAPI()\n\n\n@app.get(\'/pets\', response_model=Pets)\ndef list_pets(limit: Optional[int] = None) -> Pets:\n    pass\n\n\n@app.post(\'/pets\', response_model=None)\ndef create_pets() -> None:\n    pass\n\n\n@app.get(\'/pets/{pet_id}\', response_model=Pet)\ndef show_pet_by_id(pet_id: str) -> Pet:\n    pass\n```\n\n`app/models.py`:\n```python\n# generated by datamodel-codegen:\n#   filename:  api.yaml\n#   timestamp: 2020-06-14T10:45:22+00:00\n\nfrom typing import List, Optional\n\nfrom pydantic import BaseModel\n\n\nclass Pet(BaseModel):\n    id: int\n    name: str\n    tag: Optional[str] = None\n\n\nclass Pets(BaseModel):\n    __root__: List[Pet]\n\n\nclass Error(BaseModel):\n    code: int\n    message: str\n```\n\n\n## PyPi \n\n[https://pypi.org/project/fastapi-code-generator](https://pypi.org/project/fastapi-code-generator)\n\n## License\n\nfastapi-code-generator is released under the MIT License. http://www.opensource.org/licenses/mit-license\n\n',
    'author': 'Koudai Aono',
    'author_email': 'koxudaxi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/koxudaxi/fastapi-code-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
