# fastapi-openapi-cli

A command-line tool to export OpenAPI specifications from FastAPI applications.

## Installation

```bash
uv add fastapi-openapi-cli
```

## Usage

### Basic Usage

Export OpenAPI spec to `stdout`:

```bash
fastapi-openapi --app myapp.main:app
```

Export to JSON File:

```bash
fastapi-openapi --app myapp.main:app -o openapi.json
```

Export to YAML File:

```bash
fastapi-openapi --app myapp.main:app -o openapi.yaml
```

## Development

### Setup

This project uses [uv](https://github.com/astral-sh/uv) for dependency management:

```bash
# Clone the repository
git clone https://github.com/hectcastro/fastapi-openapi-cli.git
cd fastapi-openapi-cli

# Install dependencies
uv sync
```

### Running Tests

```bash
# Run all tests with coverage
make test

# Run specific test file
uv run pytest tests/test_cli.py

# Run without coverage
uv run pytest --no-cov
```

### Linting and Formatting

```bash
# Check code with ruff
make lint

# Format code
make format
```

### Type Checking

```bash
# Run type checking with ty
make types
```

### Dependency Analysis

```bash
# Check for dependency issues with deptry
make deps
```

### CI Pipeline

```bash
# Run all checks (lint, types, tests) - same as CI
make ci
```

### Running the CLI Locally

```bash
# Run the CLI in development
uv run fastapi-openapi --app tests.fixtures.sample_app:app
```
