from fasterpay.config import Config
from fasterpay.signature import Signature
from fasterpay.pingback import Pingback
from fasterpay.paymentform import PaymentForm
from fasterpay.refund import Refund
from fasterpay.subscription import Subscription
from fasterpay.transaction import Transaction


class Gateway:

    def __init__(self, private_key, public_key, api_url=None, api_version=None):
        self.config = Config(private_key, public_key, api_url, api_version)

    def payment_form(self):
        return PaymentForm(self)

    def signature(self):
        return Signature(self)

    def pingback(self):
        return Pingback(self)

    def get_config(self):
        return self.config

    def refund(self):
        return Refund(self)

    def subscription(self):
        return Subscription(self)

    def transaction(self):
        return Transaction(self)
