"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional


class DRMConfigurations(BaseSDK):
    def get_drm_configuration(
        self,
        *,
        offset: Optional[int] = 1,
        limit: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.DrmIDResponse]:
        r"""Get list of DRM configuration IDs


        This endpoint retrieves the DRM configuration (DRM ID) associated with a workspace. It returns a list of DRM configurations, identified by a unique DRM ID, which is used for creating DRM encrypted asset.

        **How it works:**
        1. Make a GET request to this endpoint.
        2. Optionally use the `offset` and `limit` query parameters to paginate through the list of DRM configurations.
        3. The response includes a list of DRM IDs and pagination metadata.

        **Example:**
        A media service provider may retrieve DRM configuration for a workspace to create DRM content.

        Related guide: <a href=\"https://docs.fastpix.io/docs/secure-playback-with-drm\">Manage DRM configuration</a>


        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param limit: Limit specifies the maximum number of items to display per page.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetDrmConfigurationRequest(
            offset=offset,
            limit=limit,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/drm-configurations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getDrmConfiguration",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetDrmConfigurationResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_drm_configuration_async(
        self,
        *,
        offset: Optional[int] = 1,
        limit: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.DrmIDResponse]:
        r"""Get list of DRM configuration IDs


        This endpoint retrieves the DRM configuration (DRM ID) associated with a workspace. It returns a list of DRM configurations, identified by a unique DRM ID, which is used for creating DRM encrypted asset.

        **How it works:**
        1. Make a GET request to this endpoint.
        2. Optionally use the `offset` and `limit` query parameters to paginate through the list of DRM configurations.
        3. The response includes a list of DRM IDs and pagination metadata.

        **Example:**
        A media service provider may retrieve DRM configuration for a workspace to create DRM content.

        Related guide: <a href=\"https://docs.fastpix.io/docs/secure-playback-with-drm\">Manage DRM configuration</a>


        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param limit: Limit specifies the maximum number of items to display per page.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetDrmConfigurationRequest(
            offset=offset,
            limit=limit,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/drm-configurations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getDrmConfiguration",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetDrmConfigurationResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def get_drm_configuration_by_id(
        self,
        *,
        drm_configuration_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DrmIDResponse:
        r"""Get DRM configuration by ID


        This endpoint retrieves a DRM configuration ID. It is used to fetch the DRM-related ID for a workspace, typically required when validating or applying DRM policies to video assets.

        **How it works:**
        1. Make a GET request to this endpoint, replacing `{drmConfigurationId}` with the UUID of the DRM configuration.
        2. The response will contain the associated DRM configuration ID.

        Related guide: <a href=\"https://docs.fastpix.io/docs/secure-playback-with-drm\">Manage DRM configuration</a>


        :param drm_configuration_id: The unique identifier of the DRM configuration.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetDrmConfigurationByIDRequest(
            drm_configuration_id=drm_configuration_id,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/drm-configurations/{drmConfigurationId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getDrmConfigurationById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetDrmConfigurationByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_drm_configuration_by_id_async(
        self,
        *,
        drm_configuration_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DrmIDResponse:
        r"""Get DRM configuration by ID


        This endpoint retrieves a DRM configuration ID. It is used to fetch the DRM-related ID for a workspace, typically required when validating or applying DRM policies to video assets.

        **How it works:**
        1. Make a GET request to this endpoint, replacing `{drmConfigurationId}` with the UUID of the DRM configuration.
        2. The response will contain the associated DRM configuration ID.

        Related guide: <a href=\"https://docs.fastpix.io/docs/secure-playback-with-drm\">Manage DRM configuration</a>


        :param drm_configuration_id: The unique identifier of the DRM configuration.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetDrmConfigurationByIDRequest(
            drm_configuration_id=drm_configuration_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/drm-configurations/{drmConfigurationId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getDrmConfigurationById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetDrmConfigurationByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
