"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional


class Errors(BaseSDK):
    def list_errors(
        self,
        *,
        timespan: models.ListErrorsTimespan,
        filterby: Optional[str] = None,
        limit: Optional[int] = 1,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListErrorsData:
        r"""List errors

        This endpoint returns the total number of playback errors that occurred, along with the total number of views captured, based on the specified timespan and filters. It provides insights into the overall playback quality and helps identify potential issues that may impact viewer experience.


        #### Key fields in response

        * **percentage:** The percentage of views affected by the specific error.
        * **uniqueViewersEffectedPercentage:** The percentage of unique viewers affected by the specific error (available only in the topErrors section).
        * **notes:** Additional notes or information about the specific error.
        * **message:** The error message or description.
        * **lastSeen:** The timestamp of when the error was last observed.
        * **id:** The unique identifier for the specific error.
        * **description:** A description of the specific error.
        * **count:** The number of occurrences of the specific error.
        * **code:** The error code associated with the specific error.


        Related guide: <a href=\"https://docs.fastpix.io/docs/track-playback-errors\">Troubleshoot errors</a>


        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param limit: Pass the limit to display only the rows specified by the value for top errors.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListErrorsRequest(
            timespan=timespan,
            filterby=filterby,
            limit=limit,
        )

        req = self._build_request(
            method="GET",
            path="/data/errors",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_errors",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListErrorsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_errors_async(
        self,
        *,
        timespan: models.ListErrorsTimespan,
        filterby: Optional[str] = None,
        limit: Optional[int] = 1,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListErrorsData:
        r"""List errors

        This endpoint returns the total number of playback errors that occurred, along with the total number of views captured, based on the specified timespan and filters. It provides insights into the overall playback quality and helps identify potential issues that may impact viewer experience.


        #### Key fields in response

        * **percentage:** The percentage of views affected by the specific error.
        * **uniqueViewersEffectedPercentage:** The percentage of unique viewers affected by the specific error (available only in the topErrors section).
        * **notes:** Additional notes or information about the specific error.
        * **message:** The error message or description.
        * **lastSeen:** The timestamp of when the error was last observed.
        * **id:** The unique identifier for the specific error.
        * **description:** A description of the specific error.
        * **count:** The number of occurrences of the specific error.
        * **code:** The error code associated with the specific error.


        Related guide: <a href=\"https://docs.fastpix.io/docs/track-playback-errors\">Troubleshoot errors</a>


        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param limit: Pass the limit to display only the rows specified by the value for top errors.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListErrorsRequest(
            timespan=timespan,
            filterby=filterby,
            limit=limit,
        )

        req = self._build_request_async(
            method="GET",
            path="/data/errors",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_errors",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListErrorsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
