"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from .fastpixerror import FastpixError
from ..models import (
    duplicatemp4support_error as models_duplicatemp4support_error,
)
from ..types import BaseModel
import httpx
from typing import Optional


class DuplicateMp4SupportErrorData(BaseModel):
    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    error: Optional[models_duplicatemp4support_error.DuplicateMp4SupportError] = None
    r"""Displays details about the reasons behind the request's failure."""


@dataclass(frozen=True)
class DuplicateMp4SupportError(FastpixError):
    data: DuplicateMp4SupportErrorData = field(hash=False)

    def __init__(
        self,
        data: DuplicateMp4SupportErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) if data.error else fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
