"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from .fastpixerror import FastpixError
from ..models import forbidden_error as models_forbidden_error
from ..types import BaseModel
import httpx
from typing import Optional


class ForbiddenErrorData(BaseModel):
    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    error: Optional[models_forbidden_error.ForbiddenError] = None
    r"""Displays details about the reasons behind the request's failure."""


@dataclass(frozen=True)
class ForbiddenError(FastpixError):
    data: ForbiddenErrorData = field(hash=False)

    def __init__(
        self,
        data: ForbiddenErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) if data.error else fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
