"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from .fastpixerror import FastpixError
from ..models import (
    simulcastunavailable_error as models_simulcastunavailable_error,
)
from ..types import BaseModel
import httpx
from typing import Optional


class SimulcastUnavailableErrorData(BaseModel):
    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    error: Optional[models_simulcastunavailable_error.SimulcastUnavailableError] = None
    r"""Returns the problem that has occured.

    """


@dataclass(frozen=True)
class SimulcastUnavailableError(FastpixError):
    data: SimulcastUnavailableErrorData = field(hash=False)

    def __init__(
        self,
        data: SimulcastUnavailableErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) if data.error else fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
