"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from .fastpixerror import FastpixError
from ..models import (
    trialplanrestrictionerror as models_trialplanrestrictionerror,
)
from ..types import BaseModel
import httpx
from typing import Optional


class TrialPlanRestrictionErrorData(BaseModel):
    success: Optional[bool] = None
    r"""Indicates whether the request was successful or not."""

    error: Optional[models_trialplanrestrictionerror.TrialPlanRestrictionErrorError] = (
        None
    )
    r"""Contains details explaining why the request failed."""


@dataclass(frozen=True)
class TrialPlanRestrictionError(FastpixError):
    data: TrialPlanRestrictionErrorData = field(hash=False)

    def __init__(
        self,
        data: TrialPlanRestrictionErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) if data.error else fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
