"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import BaseModel, OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union, cast


class InputVideo(BaseSDK):
    def create_media(
        self,
        *,
        inputs: Union[List[models.Input], List[models.InputTypedDict]],
        access_policy: models.CreateMediaRequestAccessPolicy,
        metadata: Optional[Dict[str, str]] = None,
        subtitles: Optional[Union[models.Subtitles, models.SubtitlesTypedDict]] = None,
        mp4_support: Optional[models.CreateMediaRequestMp4Support] = None,
        source_access: Optional[bool] = None,
        optimize_audio: Optional[bool] = False,
        max_resolution: Optional[models.CreateMediaRequestMaxResolution] = "1080p",
        summary: Optional[Union[models.Summary, models.SummaryTypedDict]] = None,
        chapters: Optional[bool] = None,
        named_entities: Optional[bool] = None,
        moderation: Optional[
            Union[models.Moderation, models.ModerationTypedDict]
        ] = None,
        access_restrictions: Optional[
            Union[
                models.CreateMediaRequestAccessRestrictions,
                models.CreateMediaRequestAccessRestrictionsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateMediaResponse:
        r"""Create media from URL

        This endpoint allows developers or users to create a new video or audio media in FastPix using a publicly accessible URL. FastPix will fetch the media from the provided URL, process it, and store it on the platform for use.



        #### Public URL requirement:


        The provided URL must be publicly accessible and should point to a video stored in one of the following supported formats: .m4v, .ogv, .mpeg, .mov, .3gp, .f4v, .rm, .ts, .wtv, .avi, .mp4, .wmv, .webm, .mts, .vob, .mxf, asf, m2ts



        #### Supported storage types:

        The URL can originate from various cloud storage services or content delivery networks (CDNs) such as:


        * **Amazon S3:** URLs from Amazon's Simple Storage Service.

        * **Google Cloud Storage:** URLs from Google Cloud's storage solution.

        * **Azure Blob Storage:** URLs from Microsoft's Azure storage.

        * **Public CDNs:** URLs from public content delivery networks that host video files.

        Upon successful creation, the API returns an `id` that should be retained for future operations related to this media.

        #### How it works


        1. Send a POST request to this endpoint with the media URL (typically a video or audio file) and optional media settings.

        2. FastPix uploads the video from the provided URL to its storage.

        3. Receive a response containing the unique id for the newly created media item.

        4. Use the id in subsequent API calls, such as checking the status of the media with the <a href=\"https://docs.fastpix.io/reference/get-media\">Get Media by ID</a> endpoint to determine when the media is ready for playback.

        FastPix uses webhooks to tell your application about things that happen in the background, outside of the API regular request flow. For instance, once the media file is created (but not yet processed or encoded), we'll shoot a `POST` message to the address you give us with the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediacreated\">video.media.created</a>.


        Once processing is done you can look for the events <a href=\"https://docs.fastpix.io/docs/media-events#/videomediaready\">video.media.ready<a/> and <a href=\"https://docs.fastpix.io/docs/media-events#videomediafailed\">video.media.failed</a> to see the status of your new media file.

        Related guide: <a href=\"https://docs.fastpix.io/docs/upload-videos-from-url\">Upload videos from URL</a>


        :param inputs:
        :param access_policy: Determines whether access to the streamed content is kept private or available to all.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param subtitles: Generates subtitle files for audio/video files.
        :param mp4_support: \"capped_4k\": Generates an mp4 video file up to 4k resolution \"audioOnly\": Generates an m4a audio file of the media file \"audioOnly,capped_4k\": Generates both video and audio media files for offline viewing
        :param source_access: The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it
        :param optimize_audio: normalize volume of the audio track. This is available for pre-recorded content only.
        :param max_resolution: The maximum resolution tier determines the highest quality your media will be available in.
        :param summary:
        :param chapters: Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.
        :param named_entities: Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.
        :param moderation:
        :param access_restrictions:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateMediaRequest(
            inputs=utils.get_pydantic_model(inputs, List[models.Input]),
            metadata=metadata,
            subtitles=utils.get_pydantic_model(subtitles, Optional[models.Subtitles]),
            access_policy=access_policy,
            mp4_support=mp4_support,
            source_access=source_access,
            optimize_audio=optimize_audio,
            max_resolution=max_resolution,
            summary=utils.get_pydantic_model(summary, Optional[models.Summary]),
            chapters=chapters,
            named_entities=named_entities,
            moderation=utils.get_pydantic_model(
                moderation, Optional[models.Moderation]
            ),
            access_restrictions=utils.get_pydantic_model(
                access_restrictions,
                Optional[models.CreateMediaRequestAccessRestrictions],
            ),
        )

        req = self._build_request(
            method="POST",
            path="/on-demand",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateMediaRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.CreateMediaSuccessResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def create_media_async(
        self,
        *,
        inputs: Union[List[models.Input], List[models.InputTypedDict]],
        access_policy: models.CreateMediaRequestAccessPolicy,
        metadata: Optional[Dict[str, str]] = None,
        subtitles: Optional[Union[models.Subtitles, models.SubtitlesTypedDict]] = None,
        mp4_support: Optional[models.CreateMediaRequestMp4Support] = None,
        source_access: Optional[bool] = None,
        optimize_audio: Optional[bool] = False,
        max_resolution: Optional[models.CreateMediaRequestMaxResolution] = "1080p",
        summary: Optional[Union[models.Summary, models.SummaryTypedDict]] = None,
        chapters: Optional[bool] = None,
        named_entities: Optional[bool] = None,
        moderation: Optional[
            Union[models.Moderation, models.ModerationTypedDict]
        ] = None,
        access_restrictions: Optional[
            Union[
                models.CreateMediaRequestAccessRestrictions,
                models.CreateMediaRequestAccessRestrictionsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateMediaResponse:
        r"""Create media from URL

        This endpoint allows developers or users to create a new video or audio media in FastPix using a publicly accessible URL. FastPix will fetch the media from the provided URL, process it, and store it on the platform for use.



        #### Public URL requirement:


        The provided URL must be publicly accessible and should point to a video stored in one of the following supported formats: .m4v, .ogv, .mpeg, .mov, .3gp, .f4v, .rm, .ts, .wtv, .avi, .mp4, .wmv, .webm, .mts, .vob, .mxf, asf, m2ts



        #### Supported storage types:

        The URL can originate from various cloud storage services or content delivery networks (CDNs) such as:


        * **Amazon S3:** URLs from Amazon's Simple Storage Service.

        * **Google Cloud Storage:** URLs from Google Cloud's storage solution.

        * **Azure Blob Storage:** URLs from Microsoft's Azure storage.

        * **Public CDNs:** URLs from public content delivery networks that host video files.

        Upon successful creation, the API returns an `id` that should be retained for future operations related to this media.

        #### How it works


        1. Send a POST request to this endpoint with the media URL (typically a video or audio file) and optional media settings.

        2. FastPix uploads the video from the provided URL to its storage.

        3. Receive a response containing the unique id for the newly created media item.

        4. Use the id in subsequent API calls, such as checking the status of the media with the <a href=\"https://docs.fastpix.io/reference/get-media\">Get Media by ID</a> endpoint to determine when the media is ready for playback.

        FastPix uses webhooks to tell your application about things that happen in the background, outside of the API regular request flow. For instance, once the media file is created (but not yet processed or encoded), we'll shoot a `POST` message to the address you give us with the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediacreated\">video.media.created</a>.


        Once processing is done you can look for the events <a href=\"https://docs.fastpix.io/docs/media-events#/videomediaready\">video.media.ready<a/> and <a href=\"https://docs.fastpix.io/docs/media-events#videomediafailed\">video.media.failed</a> to see the status of your new media file.

        Related guide: <a href=\"https://docs.fastpix.io/docs/upload-videos-from-url\">Upload videos from URL</a>


        :param inputs:
        :param access_policy: Determines whether access to the streamed content is kept private or available to all.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param subtitles: Generates subtitle files for audio/video files.
        :param mp4_support: \"capped_4k\": Generates an mp4 video file up to 4k resolution \"audioOnly\": Generates an m4a audio file of the media file \"audioOnly,capped_4k\": Generates both video and audio media files for offline viewing
        :param source_access: The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it
        :param optimize_audio: normalize volume of the audio track. This is available for pre-recorded content only.
        :param max_resolution: The maximum resolution tier determines the highest quality your media will be available in.
        :param summary:
        :param chapters: Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.
        :param named_entities: Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.
        :param moderation:
        :param access_restrictions:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateMediaRequest(
            inputs=utils.get_pydantic_model(inputs, List[models.Input]),
            metadata=metadata,
            subtitles=utils.get_pydantic_model(subtitles, Optional[models.Subtitles]),
            access_policy=access_policy,
            mp4_support=mp4_support,
            source_access=source_access,
            optimize_audio=optimize_audio,
            max_resolution=max_resolution,
            summary=utils.get_pydantic_model(summary, Optional[models.Summary]),
            chapters=chapters,
            named_entities=named_entities,
            moderation=utils.get_pydantic_model(
                moderation, Optional[models.Moderation]
            ),
            access_restrictions=utils.get_pydantic_model(
                access_restrictions,
                Optional[models.CreateMediaRequestAccessRestrictions],
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/on-demand",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateMediaRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.CreateMediaSuccessResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def direct_upload_video_media(
        self,
        *,
        request: Optional[
            Union[
                models.DirectUploadVideoMediaRequest,
                models.DirectUploadVideoMediaRequestTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DirectUpload:
        r"""Upload media from device

        This endpoint enables accelerated uploads of large media files directly from your local device to FastPix for processing and storage.

        > **PLEASE NOTE**
        >
        > This version now supports uploads with no file size limitations and offers faster uploads. The previous endpoint (which had a 500MB size limit) is now deprecated. You can find details in the [changelog](https://docs.fastpix.io/changelog/api-update-direct-upload-media-from-device).

        #### How it works

        1. Send a POST request to this endpoint with optional media settings.

        2. The response includes an `uploadId` and a signed `url` for direct video file upload.

        3. Upload your video file to the provided `url` by making `PUT` request. The API accepts the media file from the device and uploads it to the FastPix platform.

        4. Once uploaded, the media undergoes processing and is assigned a unique ID for tracking. Retain this `uploadId` for any future operations related to this upload.




        After uploading, you can use the <a href=\"https://docs.fastpix.io/reference/get-media\">Get Media by ID</a> endpoint to check the status of the uploaded media asset and see if it has transitioned to a `ready` status for playback.

        To notify your application about the status of this API request check for the webhooks for <a href=\"https://docs.fastpix.io/docs/webhooks-collection#media-related-events\">media related events</a>.


        #### Example

        A social media platform allows users to upload video content directly from their phones or computers. This endpoint facilitates the upload process. For example, if you are developing a video-sharing app where users can upload short clips from their mobile devices, this endpoint enables them to select a video, upload it to the platform.

        Related guide: <a href=\"https://docs.fastpix.io/docs/upload-videos-directly\">Upload videos directly</a>


        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, Optional[models.DirectUploadVideoMediaRequest]
            )
        request = cast(Optional[models.DirectUploadVideoMediaRequest], request)

        req = self._build_request(
            method="POST",
            path="/on-demand/upload",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                True,
                "json",
                Optional[models.DirectUploadVideoMediaRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="direct-upload-video-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.DirectUploadVideoMediaResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def direct_upload_video_media_async(
        self,
        *,
        request: Optional[
            Union[
                models.DirectUploadVideoMediaRequest,
                models.DirectUploadVideoMediaRequestTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DirectUpload:
        r"""Upload media from device

        This endpoint enables accelerated uploads of large media files directly from your local device to FastPix for processing and storage.

        > **PLEASE NOTE**
        >
        > This version now supports uploads with no file size limitations and offers faster uploads. The previous endpoint (which had a 500MB size limit) is now deprecated. You can find details in the [changelog](https://docs.fastpix.io/changelog/api-update-direct-upload-media-from-device).

        #### How it works

        1. Send a POST request to this endpoint with optional media settings.

        2. The response includes an `uploadId` and a signed `url` for direct video file upload.

        3. Upload your video file to the provided `url` by making `PUT` request. The API accepts the media file from the device and uploads it to the FastPix platform.

        4. Once uploaded, the media undergoes processing and is assigned a unique ID for tracking. Retain this `uploadId` for any future operations related to this upload.




        After uploading, you can use the <a href=\"https://docs.fastpix.io/reference/get-media\">Get Media by ID</a> endpoint to check the status of the uploaded media asset and see if it has transitioned to a `ready` status for playback.

        To notify your application about the status of this API request check for the webhooks for <a href=\"https://docs.fastpix.io/docs/webhooks-collection#media-related-events\">media related events</a>.


        #### Example

        A social media platform allows users to upload video content directly from their phones or computers. This endpoint facilitates the upload process. For example, if you are developing a video-sharing app where users can upload short clips from their mobile devices, this endpoint enables them to select a video, upload it to the platform.

        Related guide: <a href=\"https://docs.fastpix.io/docs/upload-videos-directly\">Upload videos directly</a>


        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, Optional[models.DirectUploadVideoMediaRequest]
            )
        request = cast(Optional[models.DirectUploadVideoMediaRequest], request)

        req = self._build_request_async(
            method="POST",
            path="/on-demand/upload",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                True,
                "json",
                Optional[models.DirectUploadVideoMediaRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="direct-upload-video-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.DirectUploadVideoMediaResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
