"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union


class ManageVideos(BaseSDK):
    def list_media(
        self,
        *,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Media]:
        r"""Get list of all media

        This endpoint returns a list of all media files uploaded to FastPix within a specific workspace. Each media entry contains data such as the media `id`, `createdAt`, `status`, `type` and more. It allows you to retrieve an overview of your media assets, making it easier to manage and review them.


        #### How it works

        Use the access token and secret key related to the workspace in the request header. When called, the API provides a paginated response containing all the media items in that specific workspace. This is helpful for retrieving a large volume of media and managing content in bulk.



        #### Example
        You're managing a video platform and need to check all the uploaded media in your library to ensure no outdated or low-quality content is being served. Using this endpoint, you can retrieve a complete list of media, allowing you to filter, sort, or update items as needed.


        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMediaRequest(
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_media_async(
        self,
        *,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Media]:
        r"""Get list of all media

        This endpoint returns a list of all media files uploaded to FastPix within a specific workspace. Each media entry contains data such as the media `id`, `createdAt`, `status`, `type` and more. It allows you to retrieve an overview of your media assets, making it easier to manage and review them.


        #### How it works

        Use the access token and secret key related to the workspace in the request header. When called, the API provides a paginated response containing all the media items in that specific workspace. This is helpful for retrieving a large volume of media and managing content in bulk.



        #### Example
        You're managing a video platform and need to check all the uploaded media in your library to ensure no outdated or low-quality content is being served. Using this endpoint, you can retrieve a complete list of media, allowing you to filter, sort, or update items as needed.


        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMediaRequest(
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def list_live_clips(
        self,
        *,
        livestream_id: str,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Media]:
        r"""Get all clips of a live stream

        Retrieves a list of all media clips generated from a specific livestream. Each media entry includes metadata such as the clip media IDs, and other relevant details. A media clip is a segmented portion of an original media file (source live stream). Clips are often created for various purposes such as previews, highlights, or customized edits.
        #### How it works
        To use this endpoint, provide the `livestreamId` as a parameter. The API then returns a paginated list of clipped media items created from that livestream. Pagination ensures optimal performance and usability when dealing with a large number of media files, making it easier to organize and manage content in bulk.

        Related guide: <a href=\"https://docs.fastpix.io/docs/instant-live-clipping\">Instant live clipping</a>


        :param livestream_id: The stream Id is unique identifier assigned to the live stream.
        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListLiveClipsRequest(
            livestream_id=livestream_id,
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/{livestreamId}/live-clips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-live-clips",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListLiveClipsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_live_clips_async(
        self,
        *,
        livestream_id: str,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Media]:
        r"""Get all clips of a live stream

        Retrieves a list of all media clips generated from a specific livestream. Each media entry includes metadata such as the clip media IDs, and other relevant details. A media clip is a segmented portion of an original media file (source live stream). Clips are often created for various purposes such as previews, highlights, or customized edits.
        #### How it works
        To use this endpoint, provide the `livestreamId` as a parameter. The API then returns a paginated list of clipped media items created from that livestream. Pagination ensures optimal performance and usability when dealing with a large number of media files, making it easier to organize and manage content in bulk.

        Related guide: <a href=\"https://docs.fastpix.io/docs/instant-live-clipping\">Instant live clipping</a>


        :param livestream_id: The stream Id is unique identifier assigned to the live stream.
        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListLiveClipsRequest(
            livestream_id=livestream_id,
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/{livestreamId}/live-clips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-live-clips",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListLiveClipsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def get_media(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Get a media by ID

        By calling this endpoint, you can retrieve detailed information about a specific media item, including its current `status` and a `playbackId`. This is particularly useful for retrieving specific media details when managing large content libraries.



        #### How it works



        1. Make a GET request to this endpoint, using the `<mediaId>` received after uploading the media file.


        2. Receive a response that includes details about the media:

        * `status` Indicates whether the media is still `preparing` or has transitioned to `ready`.

        * The `playbackId` is a unique identifier that allows you to stream the media once it is `ready`. You can construct the stream URL in this format: `https://stream.fastpix.io/<playbackId>.m3u8`


        #### Example

        Suppose your platform provides users with an interface where they can manage their uploaded content. A user requests detailed information about a specific video to see if it has been fully processed and is available for playback. Using the media ID, you can fetch the information from FastPix and display it in the user's dashboard.


        :param media_id: The Media Id is assigned a universal unique identifier, which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMediaRequest(
            media_id=media_id,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_media_async(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Get a media by ID

        By calling this endpoint, you can retrieve detailed information about a specific media item, including its current `status` and a `playbackId`. This is particularly useful for retrieving specific media details when managing large content libraries.



        #### How it works



        1. Make a GET request to this endpoint, using the `<mediaId>` received after uploading the media file.


        2. Receive a response that includes details about the media:

        * `status` Indicates whether the media is still `preparing` or has transitioned to `ready`.

        * The `playbackId` is a unique identifier that allows you to stream the media once it is `ready`. You can construct the stream URL in this format: `https://stream.fastpix.io/<playbackId>.m3u8`


        #### Example

        Suppose your platform provides users with an interface where they can manage their uploaded content. A user requests detailed information about a specific video to see if it has been fully processed and is available for playback. Using the media ID, you can fetch the information from FastPix and display it in the user's dashboard.


        :param media_id: The Media Id is assigned a universal unique identifier, which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMediaRequest(
            media_id=media_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def updated_media(
        self,
        *,
        media_id: str,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update a media by ID

        This endpoint allows you to update specific parameters of an existing media file. You can modify the key-value pairs of the metadata that were provided in the payload during the creation of media from a URL or when uploading the media directly from device.


        #### How it works

        1. Make a PATCH request to this endpoint, replacing `<mediaId>` with the unique ID (`uploadId` or `id`) of the media received after uploading to FastPix.

        2. Include the updated parameters in the request body.

        3. Receive a response containing the updated media data, confirming the changes made.

        Once you have made the update request, you can also look for the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> to notify your system about update status.

        #### Example
        Imagine a scenario where a user uploads a video and later realizes they need to change the title, add a new description or tags. You can use this endpoint to update the media metadata without having to re-upload the entire video.


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param metadata:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedMediaRequest(
            media_id=media_id,
            request_body=models.UpdatedMediaRequestBody(
                metadata=metadata,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedMediaRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def updated_media_async(
        self,
        *,
        media_id: str,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update a media by ID

        This endpoint allows you to update specific parameters of an existing media file. You can modify the key-value pairs of the metadata that were provided in the payload during the creation of media from a URL or when uploading the media directly from device.


        #### How it works

        1. Make a PATCH request to this endpoint, replacing `<mediaId>` with the unique ID (`uploadId` or `id`) of the media received after uploading to FastPix.

        2. Include the updated parameters in the request body.

        3. Receive a response containing the updated media data, confirming the changes made.

        Once you have made the update request, you can also look for the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> to notify your system about update status.

        #### Example
        Imagine a scenario where a user uploads a video and later realizes they need to change the title, add a new description or tags. You can use this endpoint to update the media metadata without having to re-upload the entire video.


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param metadata:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedMediaRequest(
            media_id=media_id,
            request_body=models.UpdatedMediaRequestBody(
                metadata=metadata,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedMediaRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def delete_media(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteMediaResponse:
        r"""Delete a media by ID

        This endpoint allows you to permanently delete a a specific video or audio media file along with all associated data. If you wish to remove a media from FastPix storage, use this endpoint with the `mediaId` (either `uploadId` or `id`) received during the media's creation or upload.


        #### How it works


        1. Make a DELETE request to this endpoint, replacing `<mediaId>` with the `uploadId` or the `id` of the media you want to delete.

        2. Since this action is irreversible, ensure that you no longer need the media before proceeding. Once deleted, the media cannot be retrieved or played back.

        3. Webhook event to look for: <a href=\"https://docs.fastpix.io/docs/media-events#videomediadeleted\">video.media.deleted</a>

        #### Example
        A user on a video-sharing platform decides to remove an old video from their profile, or suppose you're running a content moderation system, and one of the videos uploaded by a user violates your platform's policies. Using this endpoint, the media is permanently deleted from your library, ensuring it's no longer accessible or viewable by other users.


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteMediaRequest(
            media_id=media_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def delete_media_async(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteMediaResponse:
        r"""Delete a media by ID

        This endpoint allows you to permanently delete a a specific video or audio media file along with all associated data. If you wish to remove a media from FastPix storage, use this endpoint with the `mediaId` (either `uploadId` or `id`) received during the media's creation or upload.


        #### How it works


        1. Make a DELETE request to this endpoint, replacing `<mediaId>` with the `uploadId` or the `id` of the media you want to delete.

        2. Since this action is irreversible, ensure that you no longer need the media before proceeding. Once deleted, the media cannot be retrieved or played back.

        3. Webhook event to look for: <a href=\"https://docs.fastpix.io/docs/media-events#videomediadeleted\">video.media.deleted</a>

        #### Example
        A user on a video-sharing platform decides to remove an old video from their profile, or suppose you're running a content moderation system, and one of the videos uploaded by a user violates your platform's policies. Using this endpoint, the media is permanently deleted from your library, ensuring it's no longer accessible or viewable by other users.


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteMediaRequest(
            media_id=media_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/on-demand/{mediaId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-media",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteMediaResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def add_media_track(
        self,
        *,
        media_id: str,
        tracks: Optional[
            Union[models.AddTrackRequest, models.AddTrackRequestTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AddTrackResponse:
        r"""Add audio / subtitle track

        This endpoint allows you to add an audio or subtitle track to an existing media file using its `mediaId`. You need to provide the track `url` along with its `type` (audio or subtitle), `languageName` and `languageCode` in the request payload.


        #### How it works

        1. Send a POST request to this endpoint, replacing `{mediaId}` with the media ID (`uploadId` or `id`).

        2. Provide the necessary details in the request body.

        3. Receive a response containing a unique track ID and the details of the newly added track.


        #### Webhook events

        1. After successfully adding a track, your system will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackcreated\">video.media.track.created</a>.

        2. Once the track is processed and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackready\">video.media.track.ready</a>.

        3. Finally, an update event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> will notify your system about the media's updated status.


        #### Example
        Suppose you have a video uploaded to the FastPix platform, and you want to add an Italian audio track to it. By calling this API, you can attach an external audio file (https://static.fastpix.io/music-1.mp3) to the media file. Similarly, if you need to add subtitles in different languages, you can specify type: `subtitle` with the corresponding subtitle `url`, `languageCode` and `languageName`.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param tracks: Contains details about the track being added to the media file.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddMediaTrackRequest(
            media_id=media_id,
            request_body=models.AddMediaTrackRequestBody(
                tracks=utils.get_pydantic_model(
                    tracks, Optional[models.AddTrackRequest]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/on-demand/{mediaId}/tracks",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.AddMediaTrackRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Add-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.AddMediaTrackResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def add_media_track_async(
        self,
        *,
        media_id: str,
        tracks: Optional[
            Union[models.AddTrackRequest, models.AddTrackRequestTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AddTrackResponse:
        r"""Add audio / subtitle track

        This endpoint allows you to add an audio or subtitle track to an existing media file using its `mediaId`. You need to provide the track `url` along with its `type` (audio or subtitle), `languageName` and `languageCode` in the request payload.


        #### How it works

        1. Send a POST request to this endpoint, replacing `{mediaId}` with the media ID (`uploadId` or `id`).

        2. Provide the necessary details in the request body.

        3. Receive a response containing a unique track ID and the details of the newly added track.


        #### Webhook events

        1. After successfully adding a track, your system will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackcreated\">video.media.track.created</a>.

        2. Once the track is processed and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackready\">video.media.track.ready</a>.

        3. Finally, an update event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> will notify your system about the media's updated status.


        #### Example
        Suppose you have a video uploaded to the FastPix platform, and you want to add an Italian audio track to it. By calling this API, you can attach an external audio file (https://static.fastpix.io/music-1.mp3) to the media file. Similarly, if you need to add subtitles in different languages, you can specify type: `subtitle` with the corresponding subtitle `url`, `languageCode` and `languageName`.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param tracks: Contains details about the track being added to the media file.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddMediaTrackRequest(
            media_id=media_id,
            request_body=models.AddMediaTrackRequestBody(
                tracks=utils.get_pydantic_model(
                    tracks, Optional[models.AddTrackRequest]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/on-demand/{mediaId}/tracks",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.AddMediaTrackRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Add-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.AddMediaTrackResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def cancel_upload(
        self,
        *,
        upload_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MediaCancelResponse:
        r"""Cancel ongoing upload

        This endpoint allows you to cancel ongoing upload by its `uploadId`. Once cancelled, the upload will be marked as cancelled. Use this if a user aborts an upload or if you want to programmatically stop an in-progress upload.

        #### How it works

        1. Make a PUT request to this endpoint, replacing `{uploadId}` with the unique upload ID received after starting the upload.
        2. The response will confirm the cancellation and provide the status of the upload.

        #### Webhook Events

        Once the upload is cancelled, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediauploadcancelled-event\">video.media.upload.cancelled</a>.

        #### Example

        Suppose a user starts uploading a large video file but decides to cancel before completion. By calling this API, you can immediately stop the upload and free up resources.


        :param upload_id: When uploading the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelUploadRequest(
            upload_id=upload_id,
        )

        req = self._build_request(
            method="PUT",
            path="/on-demand/upload/{uploadId}/cancel",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="cancel-upload",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CancelUploadResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def cancel_upload_async(
        self,
        *,
        upload_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MediaCancelResponse:
        r"""Cancel ongoing upload

        This endpoint allows you to cancel ongoing upload by its `uploadId`. Once cancelled, the upload will be marked as cancelled. Use this if a user aborts an upload or if you want to programmatically stop an in-progress upload.

        #### How it works

        1. Make a PUT request to this endpoint, replacing `{uploadId}` with the unique upload ID received after starting the upload.
        2. The response will confirm the cancellation and provide the status of the upload.

        #### Webhook Events

        Once the upload is cancelled, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/media-events#videomediauploadcancelled-event\">video.media.upload.cancelled</a>.

        #### Example

        Suppose a user starts uploading a large video file but decides to cancel before completion. By calling this API, you can immediately stop the upload and free up resources.


        :param upload_id: When uploading the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelUploadRequest(
            upload_id=upload_id,
        )

        req = self._build_request_async(
            method="PUT",
            path="/on-demand/upload/{uploadId}/cancel",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="cancel-upload",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CancelUploadResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def update_media_track(
        self,
        *,
        track_id: str,
        media_id: str,
        url: Optional[str] = None,
        language_code: Optional[str] = None,
        language_name: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UpdateTrackResponse:
        r"""Update audio / subtitle track

        This endpoint allows you to update an existing audio or subtitle track associated with a media file. When updating a track, you must provide the new track `url`, `languageName`, and `languageCode`, ensuring all three parameters are included in the request.


        #### How it works

        1. Send a PATCH request to this endpoint, replacing `{mediaId}` with the media ID, and `{trackId}` with the ID of the track you want to update.

        2. Provide the necessary details in the request body.

        3. Receive a response confirming the track update.

        #### Webhook Events

        After updating a track, your system will receive webhook notifications:

        1. After successfully updating a track, your system will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackupdated\">video.media.track.updated</a>.

        2. Once the new track is processed and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackready\">video.media.track.ready</a>.

        3. Once the media file is updated with the new track details, a <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> event will be triggered.


        #### Example
        Suppose you previously added a French subtitle track to a video but now need to update it with a different file. By calling this API, you can replace the existing subtitle file (.vtt) with a new one while keeping the same track ID. This is useful when:

        - The original track file has errors and needs correction.
        - You want to improve subtitle translations or replace an audio track with a better-quality version.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param track_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param url: The direct URL of the track file. It should point to a valid audio or subtitle file.
        :param language_code: The BCP 47 language code representing the track's language.
        :param language_name: The full name of the language corresponding to the `languageCode`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateMediaTrackRequest(
            track_id=track_id,
            media_id=media_id,
            update_track_request=models.UpdateTrackRequest(
                url=url,
                language_code=language_code,
                language_name=language_name,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/on-demand/{mediaId}/tracks/{trackId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.update_track_request,
                False,
                False,
                "json",
                models.UpdateTrackRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdateMediaTrackResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def update_media_track_async(
        self,
        *,
        track_id: str,
        media_id: str,
        url: Optional[str] = None,
        language_code: Optional[str] = None,
        language_name: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UpdateTrackResponse:
        r"""Update audio / subtitle track

        This endpoint allows you to update an existing audio or subtitle track associated with a media file. When updating a track, you must provide the new track `url`, `languageName`, and `languageCode`, ensuring all three parameters are included in the request.


        #### How it works

        1. Send a PATCH request to this endpoint, replacing `{mediaId}` with the media ID, and `{trackId}` with the ID of the track you want to update.

        2. Provide the necessary details in the request body.

        3. Receive a response confirming the track update.

        #### Webhook Events

        After updating a track, your system will receive webhook notifications:

        1. After successfully updating a track, your system will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackupdated\">video.media.track.updated</a>.

        2. Once the new track is processed and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediatrackready\">video.media.track.ready</a>.

        3. Once the media file is updated with the new track details, a <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> event will be triggered.


        #### Example
        Suppose you previously added a French subtitle track to a video but now need to update it with a different file. By calling this API, you can replace the existing subtitle file (.vtt) with a new one while keeping the same track ID. This is useful when:

        - The original track file has errors and needs correction.
        - You want to improve subtitle translations or replace an audio track with a better-quality version.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param track_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param url: The direct URL of the track file. It should point to a valid audio or subtitle file.
        :param language_code: The BCP 47 language code representing the track's language.
        :param language_name: The full name of the language corresponding to the `languageCode`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateMediaTrackRequest(
            track_id=track_id,
            media_id=media_id,
            update_track_request=models.UpdateTrackRequest(
                url=url,
                language_code=language_code,
                language_name=language_name,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/on-demand/{mediaId}/tracks/{trackId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.update_track_request,
                False,
                False,
                "json",
                models.UpdateTrackRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdateMediaTrackResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def delete_media_track(
        self,
        *,
        media_id: str,
        track_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteMediaTrackResponse:
        r"""Delete audio / subtitle track

        This endpoint allows you to delete an existing audio or subtitle track from a media file. Once deleted, the track will no longer be available for playback.


        #### How it works


        1. Send a DELETE request to this endpoint, replacing `{mediaId}` with the media ID, and `{trackId}` with the ID of the track you want to remove.

        2. The track will be deleted from the media file, and you will receive a confirmation response.

        #### Webhook events

        1. After successfully deleting a track, your system will receive the webhook event **video.media.track.deleted**.

        2. Once the media file is updated to reflect the track removal, a <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> event will be triggered.


        #### Example
        Suppose you uploaded an audio track in Italian for a video but later realize it's incorrect or no longer needed. By calling this API, you can remove the specific track while keeping the rest of the media file unchanged. This is useful when:

        - A track was mistakenly added and needs to be removed.
        - The content owner requests the removal of a specific subtitle or audio track.
        - A new version of the track will be uploaded to replace the existing one.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param track_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteMediaTrackRequest(
            media_id=media_id,
            track_id=track_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/on-demand/{mediaId}/tracks/{trackId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteMediaTrackResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def delete_media_track_async(
        self,
        *,
        media_id: str,
        track_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteMediaTrackResponse:
        r"""Delete audio / subtitle track

        This endpoint allows you to delete an existing audio or subtitle track from a media file. Once deleted, the track will no longer be available for playback.


        #### How it works


        1. Send a DELETE request to this endpoint, replacing `{mediaId}` with the media ID, and `{trackId}` with the ID of the track you want to remove.

        2. The track will be deleted from the media file, and you will receive a confirmation response.

        #### Webhook events

        1. After successfully deleting a track, your system will receive the webhook event **video.media.track.deleted**.

        2. Once the media file is updated to reflect the track removal, a <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> event will be triggered.


        #### Example
        Suppose you uploaded an audio track in Italian for a video but later realize it's incorrect or no longer needed. By calling this API, you can remove the specific track while keeping the rest of the media file unchanged. This is useful when:

        - A track was mistakenly added and needs to be removed.
        - The content owner requests the removal of a specific subtitle or audio track.
        - A new version of the track will be uploaded to replace the existing one.

        Related guides: <a href=\"https://docs.fastpix.io/docs/manage-subtitle-tracks\">Add own subtitle tracks</a>, <a href=\"https://docs.fastpix.io/docs/manage-audio-tracks\">Add own audio tracks</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param track_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteMediaTrackRequest(
            media_id=media_id,
            track_id=track_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/on-demand/{mediaId}/tracks/{trackId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-media-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteMediaTrackResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def generate_subtitle_track(
        self,
        *,
        media_id: str,
        track_id: str,
        language_name: str,
        language_code: models.LanguageCode,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GenerateTrackResponse:
        r"""Generate track subtitle

        This endpoint allows you to generate subtitles for an existing audio track in a media file. By calling this API, you can generate subtitles automatically using speech recognition

        #### How it works

        1. Send a `POST` request to this endpoint, replacing `{mediaId}` with the media ID and `{trackId}` with the track ID.

        2. Provide the necessary details in the request body, including the languageName and languageCode.

        3. Receive a response containing a unique subtitle track ID and its details.

        #### Webhook Events

        1. Once the subtitle track is generated and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasubtitlegeneratedready\">video.media.subtitle.generated.ready</a>.

        2. Finally, an update event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> will notify your system about the media's updated status.

        </br> Related guide: <a href=\"https://docs.fastpix.io/docs/add-auto-generated-subtitles-to-videos\">Add auto-generated subtitles</a>


        :param media_id: A universally unique identifier (UUID) assigned to the media by FastPix.
        :param track_id: A universally unique identifier (UUID) assigned to the specific track for which subtitles should be generated.
        :param language_name: The full name of the language in which subtitles will be generated.
        :param language_code: Language code for content localization
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GenerateSubtitleTrackRequest(
            media_id=media_id,
            track_id=track_id,
            track_subtitles_generate_request=models.TrackSubtitlesGenerateRequest(
                language_name=language_name,
                metadata=metadata,
                language_code=language_code,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/on-demand/{mediaId}/tracks/{trackId}/generate-subtitles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.track_subtitles_generate_request,
                False,
                False,
                "json",
                models.TrackSubtitlesGenerateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Generate-subtitle-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GenerateSubtitleTrackResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def generate_subtitle_track_async(
        self,
        *,
        media_id: str,
        track_id: str,
        language_name: str,
        language_code: models.LanguageCode,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GenerateTrackResponse:
        r"""Generate track subtitle

        This endpoint allows you to generate subtitles for an existing audio track in a media file. By calling this API, you can generate subtitles automatically using speech recognition

        #### How it works

        1. Send a `POST` request to this endpoint, replacing `{mediaId}` with the media ID and `{trackId}` with the track ID.

        2. Provide the necessary details in the request body, including the languageName and languageCode.

        3. Receive a response containing a unique subtitle track ID and its details.

        #### Webhook Events

        1. Once the subtitle track is generated and ready, you will receive the webhook event <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasubtitlegeneratedready\">video.media.subtitle.generated.ready</a>.

        2. Finally, an update event <a href=\"https://docs.fastpix.io/docs/media-events#videomediaupdated\">video.media.updated</a> will notify your system about the media's updated status.

        </br> Related guide: <a href=\"https://docs.fastpix.io/docs/add-auto-generated-subtitles-to-videos\">Add auto-generated subtitles</a>


        :param media_id: A universally unique identifier (UUID) assigned to the media by FastPix.
        :param track_id: A universally unique identifier (UUID) assigned to the specific track for which subtitles should be generated.
        :param language_name: The full name of the language in which subtitles will be generated.
        :param language_code: Language code for content localization
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GenerateSubtitleTrackRequest(
            media_id=media_id,
            track_id=track_id,
            track_subtitles_generate_request=models.TrackSubtitlesGenerateRequest(
                language_name=language_name,
                metadata=metadata,
                language_code=language_code,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/on-demand/{mediaId}/tracks/{trackId}/generate-subtitles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.track_subtitles_generate_request,
                False,
                False,
                "json",
                models.TrackSubtitlesGenerateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Generate-subtitle-track",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GenerateSubtitleTrackResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.TrackDuplicateRequestErrorData, http_res
            )
            raise errors.TrackDuplicateRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def updated_source_access(
        self,
        *,
        media_id: str,
        source_access: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update the source access of a media by ID

        This endpoint allows you to update the `sourceAccess` setting of an existing media file. The `sourceAccess` parameter determines whether the original media file is accessible or restricted. Setting this to `true` enables access to the media source, while setting it to `false` restricts access.

        #### How it works

        1. Make a `PATCH` request to this endpoint, replacing `{mediaId}` with the ID of the media you want to update.

        2. Include the updated `sourceAccess` parameter in the request body.

        3. Receive a response confirming the update to the media's source access status.
        4. Webhook events: <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasourceready\">video.media.source.ready</a>, <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasourcedeleted\">video.media.source.deleted</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param source_access: The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedSourceAccessRequest(
            media_id=media_id,
            request_body=models.UpdatedSourceAccessRequestBody(
                source_access=source_access,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/on-demand/{mediaId}/source-access",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedSourceAccessRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-source-access",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedSourceAccessResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def updated_source_access_async(
        self,
        *,
        media_id: str,
        source_access: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update the source access of a media by ID

        This endpoint allows you to update the `sourceAccess` setting of an existing media file. The `sourceAccess` parameter determines whether the original media file is accessible or restricted. Setting this to `true` enables access to the media source, while setting it to `false` restricts access.

        #### How it works

        1. Make a `PATCH` request to this endpoint, replacing `{mediaId}` with the ID of the media you want to update.

        2. Include the updated `sourceAccess` parameter in the request body.

        3. Receive a response confirming the update to the media's source access status.
        4. Webhook events: <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasourceready\">video.media.source.ready</a>, <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediasourcedeleted\">video.media.source.deleted</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param source_access: The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedSourceAccessRequest(
            media_id=media_id,
            request_body=models.UpdatedSourceAccessRequestBody(
                source_access=source_access,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/on-demand/{mediaId}/source-access",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedSourceAccessRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-source-access",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedSourceAccessResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def updated_mp4_support(
        self,
        *,
        media_id: str,
        mp4_support: Optional[models.UpdatedMp4SupportMp4Support] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update the mp4Support of a media by ID

        This endpoint allows you to update the `mp4Support` setting of an existing media file using its media ID. You can specify the MP4 support level, such as `none`, `capped_4k`, `audioOnly`, or a combination of `audioOnly`, `capped_4k`, in the request payload.

        #### How it works

        1. Send a PATCH request to this endpoint, replacing `{mediaId}` with the media ID.

        2. Provide the desired `mp4Support` value in the request body.

        3. Receive a response confirming the update, including the media's updated MP4 support status.

        #### MP4 Support Options

        - `none` – MP4 support is disabled for this media.

        - `capped_4k` – The media will have mp4 renditions up to 4K resolution.

        - `audioOnly` – The media will generate an m4a file containing only the audio track.

        - `audioOnly,capped_4k` – The media will have both an audio-only m4a file and mp4 renditions up to 4K resolution.

        #### Webhook events

        - <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediamp4supportready\">video.media.mp4Support.ready</a> – Triggered when the MP4 support setting is successfully updated.

        #### Example
        Suppose you have a video uploaded to the FastPix platform, and you want to allow users to download the video in MP4 format. By setting \"mp4Support\": \"capped_4k\", the system will generate an MP4 rendition of the video up to 4K resolution, making it available for download via the stream URL(`https://stream.fastpix.io/{playbackId}/{capped-4k.mp4 | audio.m4a}`).
        If you want users to stream only the audio from the media file, you can set \"mp4Support\": \"audioOnly\". This will provide an audio-only stream URL that allows users to listen to the media without video.
        By setting \"mp4Support\": \"audioOnly,capped_4k\", both options will be enabled. Users will be able to download the MP4 video and also stream just the audio version of the media.


        Related guide: <a href=\"https://docs.fastpix.io/docs/mp4-support-for-offline-viewing\">Use MP4 support for offline viewing</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param mp4_support: Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedMp4SupportRequest(
            media_id=media_id,
            request_body=models.UpdatedMp4SupportRequestBody(
                mp4_support=mp4_support,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/on-demand/{mediaId}/update-mp4Support",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedMp4SupportRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-mp4Support",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedMp4SupportResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.DuplicateMp4SupportErrorData, http_res
            )
            raise errors.DuplicateMp4SupportError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def updated_mp4_support_async(
        self,
        *,
        media_id: str,
        mp4_support: Optional[models.UpdatedMp4SupportMp4Support] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Media:
        r"""Update the mp4Support of a media by ID

        This endpoint allows you to update the `mp4Support` setting of an existing media file using its media ID. You can specify the MP4 support level, such as `none`, `capped_4k`, `audioOnly`, or a combination of `audioOnly`, `capped_4k`, in the request payload.

        #### How it works

        1. Send a PATCH request to this endpoint, replacing `{mediaId}` with the media ID.

        2. Provide the desired `mp4Support` value in the request body.

        3. Receive a response confirming the update, including the media's updated MP4 support status.

        #### MP4 Support Options

        - `none` – MP4 support is disabled for this media.

        - `capped_4k` – The media will have mp4 renditions up to 4K resolution.

        - `audioOnly` – The media will generate an m4a file containing only the audio track.

        - `audioOnly,capped_4k` – The media will have both an audio-only m4a file and mp4 renditions up to 4K resolution.

        #### Webhook events

        - <a href=\"https://docs.fastpix.io/docs/transform-media-events#videomediamp4supportready\">video.media.mp4Support.ready</a> – Triggered when the MP4 support setting is successfully updated.

        #### Example
        Suppose you have a video uploaded to the FastPix platform, and you want to allow users to download the video in MP4 format. By setting \"mp4Support\": \"capped_4k\", the system will generate an MP4 rendition of the video up to 4K resolution, making it available for download via the stream URL(`https://stream.fastpix.io/{playbackId}/{capped-4k.mp4 | audio.m4a}`).
        If you want users to stream only the audio from the media file, you can set \"mp4Support\": \"audioOnly\". This will provide an audio-only stream URL that allows users to listen to the media without video.
        By setting \"mp4Support\": \"audioOnly,capped_4k\", both options will be enabled. Users will be able to download the MP4 video and also stream just the audio version of the media.


        Related guide: <a href=\"https://docs.fastpix.io/docs/mp4-support-for-offline-viewing\">Use MP4 support for offline viewing</a>


        :param media_id: When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.
        :param mp4_support: Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdatedMp4SupportRequest(
            media_id=media_id,
            request_body=models.UpdatedMp4SupportRequestBody(
                mp4_support=mp4_support,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/on-demand/{mediaId}/update-mp4Support",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdatedMp4SupportRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updated-mp4Support",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UpdatedMp4SupportResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.DuplicateMp4SupportErrorData, http_res
            )
            raise errors.DuplicateMp4SupportError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def retrieve_media_input_info(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieveMediaInputInfoData:
        r"""Get info of media inputs

        Allows you to retrieve detailed information about the media inputs associated with a specific media item. You can use this endpoint to verify the media file's input URL, track creation status, and container format. The `mediaId` (either `uploadId` or `id`) must be provided to fetch the information.


        #### How it works

        Upon making a `GET` request with the mediaId, FastPix returns a response with:

        * The public storage input `url` of the uploaded media file.

        * Information about the `tracks` associated with the media, including both video and audio tracks, indicating whether they have been successfully created.

        * The format of the uploaded media file container (e.g., MP4, MKV).

        This endpoint is particularly useful for ensuring that all necessary tracks (video and audio) have been correctly associated with the media during the upload or media creation process.


        :param media_id: Pass the list of the input objects used to create the media, along with applied settings.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RetrieveMediaInputInfoRequest(
            media_id=media_id,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/{mediaId}/input-info",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="retrieveMediaInputInfo",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RetrieveMediaInputInfoResponse, http_res
            )
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def retrieve_media_input_info_async(
        self,
        *,
        media_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieveMediaInputInfoData:
        r"""Get info of media inputs

        Allows you to retrieve detailed information about the media inputs associated with a specific media item. You can use this endpoint to verify the media file's input URL, track creation status, and container format. The `mediaId` (either `uploadId` or `id`) must be provided to fetch the information.


        #### How it works

        Upon making a `GET` request with the mediaId, FastPix returns a response with:

        * The public storage input `url` of the uploaded media file.

        * Information about the `tracks` associated with the media, including both video and audio tracks, indicating whether they have been successfully created.

        * The format of the uploaded media file container (e.g., MP4, MKV).

        This endpoint is particularly useful for ensuring that all necessary tracks (video and audio) have been correctly associated with the media during the upload or media creation process.


        :param media_id: Pass the list of the input objects used to create the media, along with applied settings.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RetrieveMediaInputInfoRequest(
            media_id=media_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/{mediaId}/input-info",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="retrieveMediaInputInfo",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RetrieveMediaInputInfoResponse, http_res
            )
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaNotFoundErrorData, http_res
            )
            raise errors.MediaNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def list_uploads(
        self,
        *,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.DirectUpload]:
        r"""Get all unused upload URLs

        This endpoint retrieves a paginated list of all unused upload signed URLs within your organization. It provides comprehensive metadata including upload IDs, creation dates, status, and URLs, helping you manage your media resources efficiently.

        An unused upload URL is a signed URL that gets generated when an user initiates upload but never completed the upload process. This can happen due to reasons like network issues, manual cancellation of upload, browser/app crashes or session timeouts.These URLs remain in the system as \"unused\" since they were created but never resulted in a successful media file upload.

        #### How it works

        - The endpoint returns metadata for all unused upload URLs in your organization's library.
        - Results are paginated to manage large datasets effectively.
        - Signed URLs expire after 24 hours from creation.
        - Each entry includes full metadata about the unused upload.



        #### Example

        A video management team for a media organization regularly uploads content to their system but often forgets to delete or utilize unused uploads. These unused uploads, which have signed URLs that expire after 24 hours, need to be managed efficiently. By using this API, they can retrieve metadata for all unused uploads, identify expired signed URLs, and decide whether to regenerate URLs, reuse the uploads, or delete them.


        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListUploadsRequest(
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/uploads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-uploads",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListUploadsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_uploads_async(
        self,
        *,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.DirectUpload]:
        r"""Get all unused upload URLs

        This endpoint retrieves a paginated list of all unused upload signed URLs within your organization. It provides comprehensive metadata including upload IDs, creation dates, status, and URLs, helping you manage your media resources efficiently.

        An unused upload URL is a signed URL that gets generated when an user initiates upload but never completed the upload process. This can happen due to reasons like network issues, manual cancellation of upload, browser/app crashes or session timeouts.These URLs remain in the system as \"unused\" since they were created but never resulted in a successful media file upload.

        #### How it works

        - The endpoint returns metadata for all unused upload URLs in your organization's library.
        - Results are paginated to manage large datasets effectively.
        - Signed URLs expire after 24 hours from creation.
        - Each entry includes full metadata about the unused upload.



        #### Example

        A video management team for a media organization regularly uploads content to their system but often forgets to delete or utilize unused uploads. These unused uploads, which have signed URLs that expire after 24 hours, need to be managed efficiently. By using this API, they can retrieve metadata for all unused uploads, identify expired signed URLs, and decide whether to regenerate URLs, reuse the uploads, or delete them.


        :param limit: Limit specifies the maximum number of items to display per page.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param order_by: The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListUploadsRequest(
            limit=limit,
            offset=offset,
            order_by=order_by,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/uploads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-uploads",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListUploadsResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def get_media_clips(
        self,
        *,
        source_media_id: str,
        offset: Optional[int] = 1,
        limit: Optional[int] = 10,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MediaClipResponseData]:
        r"""Get all clips of a media

        This endpoint retrieves a list of all media clips associated with a given source media ID. It helps in organizing and managing media's efficiently by providing metadata, including clip media IDs and other relevant details.

        A media clip is a segmented portion of an original media file (source media). Clips are often created for various purposes such as previews, highlights, or customized edits. This API allows you to fetch all such clips linked to a specific source media, making it easier to track and manage clips.


        #### How it works

        - The endpoint returns metadata for all media clips associated with the given `sourceMediaId`.
        - Results are paginated to efficiently handle large datasets.
        - Each entry includes detailed metadata such as media `id`, `duration`, and `status`.
        - Helps in organizing clips effectively by providing structured information.


        #### Example

        Imagine you're managing a video editing platform where users upload full-length videos and create short clips for social media sharing. To keep track of all clips linked to a particular video, you call this API with the sourceMediaId. The response provides a list of all associated clips, allowing you to manage, edit, or repurpose them as needed.

        Related guide: <a href=\"https://docs.fastpix.io/docs/create-clips-from-existing-media\">Create clips from existing media</a>


        :param source_media_id: The unique identifier of the source media.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param limit: The number of media clips to retrieve per request.
        :param order_by: The values in the list can be arranged in two ways DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMediaClipsRequest(
            source_media_id=source_media_id,
            offset=offset,
            limit=limit,
            order_by=order_by,
        )

        req = self._build_request(
            method="GET",
            path="/on-demand/{sourceMediaId}/media-clips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-media-clips",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MediaClipResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaClipNotFoundErrorData, http_res
            )
            raise errors.MediaClipNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_media_clips_async(
        self,
        *,
        source_media_id: str,
        offset: Optional[int] = 1,
        limit: Optional[int] = 10,
        order_by: Optional[models.SortOrder] = "desc",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MediaClipResponseData]:
        r"""Get all clips of a media

        This endpoint retrieves a list of all media clips associated with a given source media ID. It helps in organizing and managing media's efficiently by providing metadata, including clip media IDs and other relevant details.

        A media clip is a segmented portion of an original media file (source media). Clips are often created for various purposes such as previews, highlights, or customized edits. This API allows you to fetch all such clips linked to a specific source media, making it easier to track and manage clips.


        #### How it works

        - The endpoint returns metadata for all media clips associated with the given `sourceMediaId`.
        - Results are paginated to efficiently handle large datasets.
        - Each entry includes detailed metadata such as media `id`, `duration`, and `status`.
        - Helps in organizing clips effectively by providing structured information.


        #### Example

        Imagine you're managing a video editing platform where users upload full-length videos and create short clips for social media sharing. To keep track of all clips linked to a particular video, you call this API with the sourceMediaId. The response provides a list of all associated clips, allowing you to manage, edit, or repurpose them as needed.

        Related guide: <a href=\"https://docs.fastpix.io/docs/create-clips-from-existing-media\">Create clips from existing media</a>


        :param source_media_id: The unique identifier of the source media.
        :param offset: Offset determines the starting point for data retrieval within a paginated list.
        :param limit: The number of media clips to retrieve per request.
        :param order_by: The values in the list can be arranged in two ways DESC (Descending) or ASC (Ascending).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMediaClipsRequest(
            source_media_id=source_media_id,
            offset=offset,
            limit=limit,
            order_by=order_by,
        )

        req = self._build_request_async(
            method="GET",
            path="/on-demand/{sourceMediaId}/media-clips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-media-clips",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MediaClipResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MediaClipNotFoundErrorData, http_res
            )
            raise errors.MediaClipNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
