"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional


class Metrics(BaseSDK):
    def list_breakdown_values(
        self,
        *,
        metric_id: models.ListBreakdownValuesMetricID,
        timespan: models.ListBreakdownValuesTimespan,
        filterby: Optional[str] = None,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        group_by: Optional[str] = None,
        order_by: Optional[str] = "views",
        sort_order: Optional[models.ListBreakdownValuesSortOrder] = "asc",
        measurement: Optional[str] = "avg",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MetricsBreakdownDetails]:
        r"""List breakdown values

        Retrieves breakdown values for a specified metric and timespan, allowing you to analyze the performance of your content based on various dimensions. It provides insights into how different factors contribute to the overall metrics.

        #### How it works

        1. Before using this endpoint, you can call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">List Dimensions</a> endpoint to retrieve all available dimensions that can be used in your query.

        2. Make a `GET` request to this endpoint with the required `metricId` and other query parameters.

        3. Receive a response containing the breakdown values for the specified metric, grouped and filtered according to your parameters.

        4. Upon successful retrieval, the response will include the breakdown values based on the specified parameters. Note that the time values ( `totalWatchTime` and `totalPlayingTime` ) are in milliseconds.


        #### Example


        A developer wants to analyze how watch time varies across different device types. By calling this endpoint for the `playing_time` metric and filtering by `device_type`, they can understand how engagement differs between mobile, desktop, and tablet users. This data will guide optimization efforts for different platforms.


        Related guide: <a href=\"https://docs.fastpix.io/docs/metrics-overview\">Understand data definitions</a>


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param limit: Pass the limit to display only the rows specified by the value.
        :param offset: Pass the offset value to indicate the page number.
        :param group_by: Pass this value to group the metrics list by. Possible Values : [\"browser_name\", \"browser_version\", \"os_name\",\"os_version\" , \"device_name\", \"device_model\", \"device_type\", \"device_manufacturer\", \"player_remote_played\",player_name\", \"player_version\", \"player_software_name\", \"player_software_version\", \"player_resolution\", \"fp_sdk\",\"fp_sdk_version\", \"player_autoplay_on\", \"player_preload_on\",\"video_title\",  \"video_id\", \"video_series\" ,  \"fp_playback_id\",\"fp_live_stream_id\", \"media_id\",\"video_source_stream_type\", \"video_source_type\", \"video_encoding_variant\", \"experiment_name\", \"sub_property_id\", \"drm_type\",\"asn_name\", \"cdn\", \"video_source_hostname\", \"connection_type\", \"view_session_id\",\"continent\",\"country\", \"region\",\"viewer_id\", \"error_code\", \"exit_before_video_start\", \"view_has_ad\", \"video_startup_failed\" , \"page_context\", \"playback_failed\".]
        :param order_by: Pass this value to order the metrics list by.
        :param sort_order: The order direction to sort the metrics list by.
        :param measurement: The measurement for the given metrics.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListBreakdownValuesRequest(
            metric_id=metric_id,
            timespan=timespan,
            filterby=filterby,
            limit=limit,
            offset=offset,
            group_by=group_by,
            order_by=order_by,
            sort_order=sort_order,
            measurement=measurement,
        )

        req = self._build_request(
            method="GET",
            path="/data/metrics/{metricId}/breakdown",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_breakdown_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListBreakdownValuesResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_breakdown_values_async(
        self,
        *,
        metric_id: models.ListBreakdownValuesMetricID,
        timespan: models.ListBreakdownValuesTimespan,
        filterby: Optional[str] = None,
        limit: Optional[int] = 10,
        offset: Optional[int] = 1,
        group_by: Optional[str] = None,
        order_by: Optional[str] = "views",
        sort_order: Optional[models.ListBreakdownValuesSortOrder] = "asc",
        measurement: Optional[str] = "avg",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MetricsBreakdownDetails]:
        r"""List breakdown values

        Retrieves breakdown values for a specified metric and timespan, allowing you to analyze the performance of your content based on various dimensions. It provides insights into how different factors contribute to the overall metrics.

        #### How it works

        1. Before using this endpoint, you can call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">List Dimensions</a> endpoint to retrieve all available dimensions that can be used in your query.

        2. Make a `GET` request to this endpoint with the required `metricId` and other query parameters.

        3. Receive a response containing the breakdown values for the specified metric, grouped and filtered according to your parameters.

        4. Upon successful retrieval, the response will include the breakdown values based on the specified parameters. Note that the time values ( `totalWatchTime` and `totalPlayingTime` ) are in milliseconds.


        #### Example


        A developer wants to analyze how watch time varies across different device types. By calling this endpoint for the `playing_time` metric and filtering by `device_type`, they can understand how engagement differs between mobile, desktop, and tablet users. This data will guide optimization efforts for different platforms.


        Related guide: <a href=\"https://docs.fastpix.io/docs/metrics-overview\">Understand data definitions</a>


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param limit: Pass the limit to display only the rows specified by the value.
        :param offset: Pass the offset value to indicate the page number.
        :param group_by: Pass this value to group the metrics list by. Possible Values : [\"browser_name\", \"browser_version\", \"os_name\",\"os_version\" , \"device_name\", \"device_model\", \"device_type\", \"device_manufacturer\", \"player_remote_played\",player_name\", \"player_version\", \"player_software_name\", \"player_software_version\", \"player_resolution\", \"fp_sdk\",\"fp_sdk_version\", \"player_autoplay_on\", \"player_preload_on\",\"video_title\",  \"video_id\", \"video_series\" ,  \"fp_playback_id\",\"fp_live_stream_id\", \"media_id\",\"video_source_stream_type\", \"video_source_type\", \"video_encoding_variant\", \"experiment_name\", \"sub_property_id\", \"drm_type\",\"asn_name\", \"cdn\", \"video_source_hostname\", \"connection_type\", \"view_session_id\",\"continent\",\"country\", \"region\",\"viewer_id\", \"error_code\", \"exit_before_video_start\", \"view_has_ad\", \"video_startup_failed\" , \"page_context\", \"playback_failed\".]
        :param order_by: Pass this value to order the metrics list by.
        :param sort_order: The order direction to sort the metrics list by.
        :param measurement: The measurement for the given metrics.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListBreakdownValuesRequest(
            metric_id=metric_id,
            timespan=timespan,
            filterby=filterby,
            limit=limit,
            offset=offset,
            group_by=group_by,
            order_by=order_by,
            sort_order=sort_order,
            measurement=measurement,
        )

        req = self._build_request_async(
            method="GET",
            path="/data/metrics/{metricId}/breakdown",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_breakdown_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListBreakdownValuesResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def list_overall_values(
        self,
        *,
        metric_id: models.ListOverallValuesMetricID,
        timespan: models.ListOverallValuesTimespan,
        measurement: Optional[str] = "avg",
        filterby: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MetricsOverallDataDetails:
        r"""List overall values

        Retrieves overall values for a specified metric, providing summary statistics that help you understand the performance of your content. The response includes key metrics such as `totalWatchTime`, `uniqueViews`, `totalPlayTime` and `totalViews`.

        #### How it works

        1. Before using this endpoint, you can call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">list dimensions</a> endpoint to retrieve all available dimensions that can be used in your query.

        2. Make a `GET` request to this endpoint with the required `metricId` and other query parameters.

        3. Receive a response containing the overall values for the specified metric, which may vary based on the applied filters.






        #### Key fields in response


        * **value:** The specific metric value calculated based on the applied filters.
        * **totalWatchTime:** Total time watched across all views, represented in milliseconds.
        * **uniqueViews:** The count of unique viewers who interacted with the content.
        * **totalViews:** The total number of views recorded.
        * **totalPlayTime:** Total time spent playing the video, represented in milliseconds.
        * **globalValue:** A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan. This value is not affected by specific filters.


        Related guide: <a href=\"https://docs.fastpix.io/docs/metrics-overview\">Understand data definitions</a>


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param measurement: The measurement for the given metrics. Possible Values : [95th, median, avg, count or sum]
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListOverallValuesRequest(
            metric_id=metric_id,
            measurement=measurement,
            timespan=timespan,
            filterby=filterby,
        )

        req = self._build_request(
            method="GET",
            path="/data/metrics/{metricId}/overall",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_overall_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListOverallValuesResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_overall_values_async(
        self,
        *,
        metric_id: models.ListOverallValuesMetricID,
        timespan: models.ListOverallValuesTimespan,
        measurement: Optional[str] = "avg",
        filterby: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MetricsOverallDataDetails:
        r"""List overall values

        Retrieves overall values for a specified metric, providing summary statistics that help you understand the performance of your content. The response includes key metrics such as `totalWatchTime`, `uniqueViews`, `totalPlayTime` and `totalViews`.

        #### How it works

        1. Before using this endpoint, you can call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">list dimensions</a> endpoint to retrieve all available dimensions that can be used in your query.

        2. Make a `GET` request to this endpoint with the required `metricId` and other query parameters.

        3. Receive a response containing the overall values for the specified metric, which may vary based on the applied filters.






        #### Key fields in response


        * **value:** The specific metric value calculated based on the applied filters.
        * **totalWatchTime:** Total time watched across all views, represented in milliseconds.
        * **uniqueViews:** The count of unique viewers who interacted with the content.
        * **totalViews:** The total number of views recorded.
        * **totalPlayTime:** Total time spent playing the video, represented in milliseconds.
        * **globalValue:** A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan. This value is not affected by specific filters.


        Related guide: <a href=\"https://docs.fastpix.io/docs/metrics-overview\">Understand data definitions</a>


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param measurement: The measurement for the given metrics. Possible Values : [95th, median, avg, count or sum]
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListOverallValuesRequest(
            metric_id=metric_id,
            measurement=measurement,
            timespan=timespan,
            filterby=filterby,
        )

        req = self._build_request_async(
            method="GET",
            path="/data/metrics/{metricId}/overall",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_overall_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ListOverallValuesResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def get_timeseries_data(
        self,
        *,
        metric_id: models.GetTimeseriesDataMetricID,
        timespan: models.GetTimeseriesDataTimespan,
        group_by: Optional[models.GroupBy] = "minute",
        sort_order: Optional[models.GetTimeseriesDataSortOrder] = "asc",
        measurement: Optional[str] = "avg",
        filterby: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MetricsTimeseriesDataDetails]:
        r"""Get timeseries data

        This endpoint retrieves timeseries data for a specified metric, providing insights into how the metric values change over time. The response includes an array of data points, each representing the metric's value at specific intervals.

        Each data point contains the following fields:

        * **intervalTime:** The timestamp for the data point indicating when the metric value was recorded.
        * **metricValue:** The value of the specified metric at the given interval, reflecting the performance or engagement level during that time.
        * **numberOfViews:** The total number of views recorded during that interval, providing context for the metric value.


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param group_by: Pass this value to group the metrics list by.
        :param sort_order: The order direction to sort the metrics list by.
        :param measurement: The measurement for the given metrics. Possible Values : [95th, median, avg, count or sum]
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetTimeseriesDataRequest(
            metric_id=metric_id,
            group_by=group_by,
            sort_order=sort_order,
            measurement=measurement,
            timespan=timespan,
            filterby=filterby,
        )

        req = self._build_request(
            method="GET",
            path="/data/metrics/{metricId}/timeseries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_timeseries_data",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetTimeseriesDataResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_timeseries_data_async(
        self,
        *,
        metric_id: models.GetTimeseriesDataMetricID,
        timespan: models.GetTimeseriesDataTimespan,
        group_by: Optional[models.GroupBy] = "minute",
        sort_order: Optional[models.GetTimeseriesDataSortOrder] = "asc",
        measurement: Optional[str] = "avg",
        filterby: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.MetricsTimeseriesDataDetails]:
        r"""Get timeseries data

        This endpoint retrieves timeseries data for a specified metric, providing insights into how the metric values change over time. The response includes an array of data points, each representing the metric's value at specific intervals.

        Each data point contains the following fields:

        * **intervalTime:** The timestamp for the data point indicating when the metric value was recorded.
        * **metricValue:** The value of the specified metric at the given interval, reflecting the performance or engagement level during that time.
        * **numberOfViews:** The total number of views recorded during that interval, providing context for the metric value.


        :param metric_id: Pass metric Id
        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param group_by: Pass this value to group the metrics list by.
        :param sort_order: The order direction to sort the metrics list by.
        :param measurement: The measurement for the given metrics. Possible Values : [95th, median, avg, count or sum]
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetTimeseriesDataRequest(
            metric_id=metric_id,
            group_by=group_by,
            sort_order=sort_order,
            measurement=measurement,
            timespan=timespan,
            filterby=filterby,
        )

        req = self._build_request_async(
            method="GET",
            path="/data/metrics/{metricId}/timeseries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_timeseries_data",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetTimeseriesDataResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def list_comparison_values(
        self,
        *,
        timespan: models.ListComparisonValuesTimespan,
        filterby: Optional[str] = None,
        dimension: Optional[models.ListComparisonValuesDimension] = None,
        value: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[List[models.MetricsComparisonDetails]]:
        r"""List comparison values

        This endpoint allows you to compare multiple metrics across specified dimensions. You can specify the metrics you want to compare in the query parameters, and the response will include the relevant metrics for the specified dimensions.

        #### How it works

        1. Before making a request to this endpoint, call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">list dimensions</a> endpoint to obtain all available dimensions that can be used for comparison.

        2. Make a `GET` request to this endpoint with the desired metrics specified in the query parameters.

        3. Receive a response containing the comparison values for the specified metrics across the selected dimensions.


        Related guide: <a href=\"https://docs.fastpix.io/docs/understand-dashboard-ui#compare-metrics\">Compare metrics in dashboard</a>


        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param dimension: The dimension id in which the views are watched.
        :param value: The value for the selected dimension.  For example:  If `dimension` is `browser_name`, the value could be  `Chrome` `,` `Firefox` `etc` .  If `dimension` is `os_name`, the value could be `macOS` `,` `Windows` `etc` .
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListComparisonValuesRequest(
            timespan=timespan,
            filterby=filterby,
            dimension=dimension,
            value=value,
        )

        req = self._build_request(
            method="GET",
            path="/data/metrics/comparison",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_comparison_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ListComparisonValuesResponse, http_res
            )
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def list_comparison_values_async(
        self,
        *,
        timespan: models.ListComparisonValuesTimespan,
        filterby: Optional[str] = None,
        dimension: Optional[models.ListComparisonValuesDimension] = None,
        value: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[List[models.MetricsComparisonDetails]]:
        r"""List comparison values

        This endpoint allows you to compare multiple metrics across specified dimensions. You can specify the metrics you want to compare in the query parameters, and the response will include the relevant metrics for the specified dimensions.

        #### How it works

        1. Before making a request to this endpoint, call the <a href=\"https://docs.fastpix.io/reference/list_dimensions\">list dimensions</a> endpoint to obtain all available dimensions that can be used for comparison.

        2. Make a `GET` request to this endpoint with the desired metrics specified in the query parameters.

        3. Receive a response containing the comparison values for the specified metrics across the selected dimensions.


        Related guide: <a href=\"https://docs.fastpix.io/docs/understand-dashboard-ui#compare-metrics\">Compare metrics in dashboard</a>


        :param timespan: This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.
        :param filterby: Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint. Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]
        :param dimension: The dimension id in which the views are watched.
        :param value: The value for the selected dimension.  For example:  If `dimension` is `browser_name`, the value could be  `Chrome` `,` `Firefox` `etc` .  If `dimension` is `os_name`, the value could be `macOS` `,` `Windows` `etc` .
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListComparisonValuesRequest(
            timespan=timespan,
            filterby=filterby,
            dimension=dimension,
            value=value,
        )

        req = self._build_request_async(
            method="GET",
            path="/data/metrics/comparison",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_comparison_values",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ListComparisonValuesResponse, http_res
            )
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.ViewNotFoundErrorData, http_res
            )
            raise errors.ViewNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
