"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .addtrackrequest import AddTrackRequest, AddTrackRequestTypedDict
from .addtrackresponse import AddTrackResponse, AddTrackResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AddMediaTrackRequestBodyTypedDict(TypedDict):
    tracks: NotRequired[AddTrackRequestTypedDict]
    r"""Contains details about the track being added to the media file."""


class AddMediaTrackRequestBody(BaseModel):
    tracks: Optional[AddTrackRequest] = None
    r"""Contains details about the track being added to the media file."""


class AddMediaTrackRequestTypedDict(TypedDict):
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    request_body: AddMediaTrackRequestBodyTypedDict


class AddMediaTrackRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    request_body: Annotated[
        AddMediaTrackRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class AddMediaTrackResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[AddTrackResponseTypedDict]
    r"""Contains details about the track that was added or updated."""


class AddMediaTrackResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[AddTrackResponse] = None
    r"""Contains details about the track that was added or updated."""
