"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AddTrackRequestType = Literal[
    "audio",
    "subtitle",
]
r"""Specifies the type of track being added. It can be either `audio` or `subtitle`."""


class AddTrackRequestTypedDict(TypedDict):
    r"""Contains details about the track being added to the media file."""

    url: NotRequired[str]
    r"""The direct URL of the track file. It should point to a valid audio or subtitle file."""
    type: NotRequired[AddTrackRequestType]
    r"""Specifies the type of track being added. It can be either `audio` or `subtitle`."""
    language_code: NotRequired[str]
    r"""The BCP 47 language code representing the track's language."""
    language_name: NotRequired[str]
    r"""The full name of the language corresponding to the `languageCode`."""


class AddTrackRequest(BaseModel):
    r"""Contains details about the track being added to the media file."""

    url: Optional[str] = None
    r"""The direct URL of the track file. It should point to a valid audio or subtitle file."""

    type: Optional[AddTrackRequestType] = None
    r"""Specifies the type of track being added. It can be either `audio` or `subtitle`."""

    language_code: Annotated[Optional[str], pydantic.Field(alias="languageCode")] = None
    r"""The BCP 47 language code representing the track's language."""

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""The full name of the language corresponding to the `languageCode`."""
