"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AddTrackResponseType = Literal[
    "audio",
    "subtitle",
]
r"""Specifies the type of track (audio or subtitle)."""


class AddTrackResponseTypedDict(TypedDict):
    r"""Contains details about the track that was added or updated."""

    id: NotRequired[str]
    r"""The unique identifier of the track."""
    type: NotRequired[AddTrackResponseType]
    r"""Specifies the type of track (audio or subtitle)."""
    url: NotRequired[str]
    r"""The direct URL of the track file."""
    language_code: NotRequired[str]
    r"""The BCP 47 language code representing the track's language."""
    language_name: NotRequired[str]
    r"""The full name of the language corresponding to the `languageCode`."""


class AddTrackResponse(BaseModel):
    r"""Contains details about the track that was added or updated."""

    id: Optional[str] = None
    r"""The unique identifier of the track."""

    type: Optional[AddTrackResponseType] = None
    r"""Specifies the type of track (audio or subtitle)."""

    url: Optional[str] = None
    r"""The direct URL of the track file."""

    language_code: Annotated[Optional[str], pydantic.Field(alias="languageCode")] = None
    r"""The BCP 47 language code representing the track's language."""

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""The full name of the language corresponding to the `languageCode`."""
