"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AudioInputType = Literal["audio",]
r"""Type of overlay (currently only supports 'audio')."""


class ImposeTrackTypedDict(TypedDict):
    url: NotRequired[str]
    r"""URL of the audio track to impose on the video."""
    start_time: NotRequired[int]
    r"""Start time (in seconds) of the imposed audio in the video."""
    end_time: NotRequired[int]
    r"""End time (in seconds) of the imposed audio in the video."""
    fade_in_level: NotRequired[int]
    r"""Level of fade-in effect (in seconds) at the start of the imposed audio."""
    fade_out_level: NotRequired[int]
    r"""Level of fade-out effect (in seconds) at the end of the imposed audio."""


class ImposeTrack(BaseModel):
    url: Optional[str] = None
    r"""URL of the audio track to impose on the video."""

    start_time: Annotated[Optional[int], pydantic.Field(alias="startTime")] = None
    r"""Start time (in seconds) of the imposed audio in the video."""

    end_time: Annotated[Optional[int], pydantic.Field(alias="endTime")] = None
    r"""End time (in seconds) of the imposed audio in the video."""

    fade_in_level: Annotated[Optional[int], pydantic.Field(alias="fadeInLevel")] = None
    r"""Level of fade-in effect (in seconds) at the start of the imposed audio."""

    fade_out_level: Annotated[Optional[int], pydantic.Field(alias="fadeOutLevel")] = (
        None
    )
    r"""Level of fade-out effect (in seconds) at the end of the imposed audio."""


class AudioInputTypedDict(TypedDict):
    type: NotRequired[AudioInputType]
    r"""Type of overlay (currently only supports 'audio')."""
    swap_track_url: NotRequired[str]
    r"""URL of the audio track to replace the existing audio in the video."""
    impose_tracks: NotRequired[List[ImposeTrackTypedDict]]
    r"""List of additional audio tracks to overlay on the video."""


class AudioInput(BaseModel):
    type: Optional[AudioInputType] = None
    r"""Type of overlay (currently only supports 'audio')."""

    swap_track_url: Annotated[Optional[str], pydantic.Field(alias="swapTrackUrl")] = (
        None
    )
    r"""URL of the audio track to replace the existing audio in the video."""

    impose_tracks: Annotated[
        Optional[List[ImposeTrack]], pydantic.Field(alias="imposeTracks")
    ] = None
    r"""List of additional audio tracks to overlay on the video."""
