"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .mediacancelresponse import MediaCancelResponse, MediaCancelResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CancelUploadRequestTypedDict(TypedDict):
    upload_id: str
    r"""When uploading the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""


class CancelUploadRequest(BaseModel):
    upload_id: Annotated[
        str,
        pydantic.Field(alias="uploadId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When uploading the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""


class CancelUploadResponseTypedDict(TypedDict):
    r"""Upload cancelled successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[MediaCancelResponseTypedDict]
    r"""Response returned when an upload is cancelled."""


class CancelUploadResponse(BaseModel):
    r"""Upload cancelled successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[MediaCancelResponse] = None
    r"""Response returned when an upload is cancelled."""
