"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .accesspolicy import AccessPolicy
from .domainrestrictions import DomainRestrictions, DomainRestrictionsTypedDict
from .playbackid import PlaybackID, PlaybackIDTypedDict
from .useragentrestrictions import UserAgentRestrictions, UserAgentRestrictionsTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateMediaPlaybackIDAccessRestrictionsTypedDict(TypedDict):
    domains: NotRequired[DomainRestrictionsTypedDict]
    r"""Restrictions based on the originating domain of a request"""
    user_agents: NotRequired[UserAgentRestrictionsTypedDict]
    r"""Restrictions based on the user agent"""


class CreateMediaPlaybackIDAccessRestrictions(BaseModel):
    domains: Optional[DomainRestrictions] = None
    r"""Restrictions based on the originating domain of a request"""

    user_agents: Annotated[
        Optional[UserAgentRestrictions], pydantic.Field(alias="userAgents")
    ] = None
    r"""Restrictions based on the user agent"""


Resolution = Literal[
    "480p",
    "720p",
    "1080p",
    "1440p",
    "2160p",
]
r"""The maximum resolution for the playback ID."""


class CreateMediaPlaybackIDRequestBodyTypedDict(TypedDict):
    r"""Request body for creating playback id for an media"""

    access_policy: AccessPolicy
    r"""Access policy for media content"""
    access_restrictions: NotRequired[CreateMediaPlaybackIDAccessRestrictionsTypedDict]
    drm_configuration_id: NotRequired[str]
    r"""DRM configuration ID (required if accessPolicy is 'drm')"""
    resolution: NotRequired[Resolution]
    r"""The maximum resolution for the playback ID."""


class CreateMediaPlaybackIDRequestBody(BaseModel):
    r"""Request body for creating playback id for an media"""

    access_policy: Annotated[AccessPolicy, pydantic.Field(alias="accessPolicy")]
    r"""Access policy for media content"""

    access_restrictions: Annotated[
        Optional[CreateMediaPlaybackIDAccessRestrictions],
        pydantic.Field(alias="accessRestrictions"),
    ] = None

    drm_configuration_id: Annotated[
        Optional[str], pydantic.Field(alias="drmConfigurationId")
    ] = None
    r"""DRM configuration ID (required if accessPolicy is 'drm')"""

    resolution: Optional[Resolution] = None
    r"""The maximum resolution for the playback ID."""


class CreateMediaPlaybackIDRequestTypedDict(TypedDict):
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    request_body: NotRequired[CreateMediaPlaybackIDRequestBodyTypedDict]
    r"""Request body for creating playback id for an media"""


class CreateMediaPlaybackIDRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    request_body: Annotated[
        Optional[CreateMediaPlaybackIDRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
    r"""Request body for creating playback id for an media"""


class CreateMediaPlaybackIDDataTypedDict(TypedDict):
    r"""Displays the result of the request."""

    playback_ids: NotRequired[List[PlaybackIDTypedDict]]
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""


class CreateMediaPlaybackIDData(BaseModel):
    r"""Displays the result of the request."""

    playback_ids: Annotated[
        Optional[List[PlaybackID]], pydantic.Field(alias="playbackIds")
    ] = None
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""


class CreateMediaPlaybackIDResponseTypedDict(TypedDict):
    r"""Playback id for an media"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[CreateMediaPlaybackIDDataTypedDict]
    r"""Displays the result of the request."""


class CreateMediaPlaybackIDResponse(BaseModel):
    r"""Playback id for an media"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[CreateMediaPlaybackIDData] = None
    r"""Displays the result of the request."""
