"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .basicaccesspolicy import BasicAccessPolicy
from .playbacksettings import PlaybackSettings, PlaybackSettingsTypedDict
from ..types import BaseModel
import pydantic
from typing import Dict, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CreateLiveStreamRequestMaxResolution = Literal[
    "1080p",
    "720p",
    "480p",
]
r"""Max resolution can be used to control the maximum resolution your media is encoded, stored, and streamed at."""


class InputMediaSettingsTypedDict(TypedDict):
    r"""Displays the result of the input Media settings."""

    max_resolution: NotRequired[CreateLiveStreamRequestMaxResolution]
    r"""Max resolution can be used to control the maximum resolution your media is encoded, stored, and streamed at."""
    reconnect_window: NotRequired[int]
    r"""In case the software streaming the live, gets disrupted for any reason and gets disconnected from FastPix, the reconnect window specifies the time span FastPix will wait before ending the stream. Before starting the stream, you can set the reconnect window time which is up to 1800 seconds."""
    media_policy: NotRequired[BasicAccessPolicy]
    r"""Basic access policy for media content"""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    enable_dvr_mode: NotRequired[bool]
    r"""Enables DVR (Digital Video Recorder) functionality for the live stream. When set to true, viewers can pause, rewind, and resume playback during the live broadcast. This allows time-shifted viewing of the stream while it is still ongoing."""


class InputMediaSettings(BaseModel):
    r"""Displays the result of the input Media settings."""

    max_resolution: Annotated[
        Optional[CreateLiveStreamRequestMaxResolution],
        pydantic.Field(alias="maxResolution"),
    ] = "1080p"
    r"""Max resolution can be used to control the maximum resolution your media is encoded, stored, and streamed at."""

    reconnect_window: Annotated[
        Optional[int], pydantic.Field(alias="reconnectWindow")
    ] = 60
    r"""In case the software streaming the live, gets disrupted for any reason and gets disconnected from FastPix, the reconnect window specifies the time span FastPix will wait before ending the stream. Before starting the stream, you can set the reconnect window time which is up to 1800 seconds."""

    media_policy: Annotated[
        Optional[BasicAccessPolicy], pydantic.Field(alias="mediaPolicy")
    ] = None
    r"""Basic access policy for media content"""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    enable_dvr_mode: Annotated[
        Optional[bool], pydantic.Field(alias="enableDvrMode")
    ] = None
    r"""Enables DVR (Digital Video Recorder) functionality for the live stream. When set to true, viewers can pause, rewind, and resume playback during the live broadcast. This allows time-shifted viewing of the stream while it is still ongoing."""


class CreateLiveStreamRequestTypedDict(TypedDict):
    playback_settings: PlaybackSettingsTypedDict
    r"""Displays the result of the playback settings."""
    input_media_settings: InputMediaSettingsTypedDict
    r"""Displays the result of the input Media settings."""


class CreateLiveStreamRequest(BaseModel):
    playback_settings: Annotated[
        PlaybackSettings, pydantic.Field(alias="playbackSettings")
    ]
    r"""Displays the result of the playback settings."""

    input_media_settings: Annotated[
        InputMediaSettings, pydantic.Field(alias="inputMediaSettings")
    ]
    r"""Displays the result of the input Media settings."""
