"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .audioinput import AudioInput, AudioInputTypedDict
from .mediatype import MediaType
from .policyaction import PolicyAction
from .subtitleinput import SubtitleInput, SubtitleInputTypedDict
from .videoinput import VideoInput, VideoInputTypedDict
from .watermarkinput import WatermarkInput, WatermarkInputTypedDict
from ..types import BaseModel
import pydantic
from typing import Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


InputTypedDict = TypeAliasType(
    "InputTypedDict",
    Union[
        AudioInputTypedDict,
        SubtitleInputTypedDict,
        WatermarkInputTypedDict,
        VideoInputTypedDict,
    ],
)


Input = TypeAliasType(
    "Input", Union[AudioInput, SubtitleInput, WatermarkInput, VideoInput]
)


CreateMediaRequestLanguageCode = Literal[
    "en",
    "it",
    "pl",
    "es",
    "fr",
    "ru",
    "nl",
]
r"""Language codes are concise, standardized symbols that denote languages, utilizing either two or three characters for identification. The language code must be compliant with the BCP 47 standard to ensure compatibility. (for text only).

"""


class SubtitlesTypedDict(TypedDict):
    r"""Generates subtitle files for audio/video files."""

    language_name: NotRequired[str]
    r"""Name of the language in which the subtitles will be generated.

    """
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    language_code: NotRequired[CreateMediaRequestLanguageCode]
    r"""Language codes are concise, standardized symbols that denote languages, utilizing either two or three characters for identification. The language code must be compliant with the BCP 47 standard to ensure compatibility. (for text only).

    """


class Subtitles(BaseModel):
    r"""Generates subtitle files for audio/video files."""

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""Name of the language in which the subtitles will be generated.

    """

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    language_code: Annotated[
        Optional[CreateMediaRequestLanguageCode], pydantic.Field(alias="languageCode")
    ] = None
    r"""Language codes are concise, standardized symbols that denote languages, utilizing either two or three characters for identification. The language code must be compliant with the BCP 47 standard to ensure compatibility. (for text only).

    """


CreateMediaRequestAccessPolicy = Literal[
    "public",
    "private",
    "drm",
]
r"""Determines whether access to the streamed content is kept private or available to all.

"""


CreateMediaRequestMp4Support = Literal[
    "capped_4k",
    "audioOnly",
    "audioOnly,capped_4k",
]
r"""\"capped_4k\": Generates an mp4 video file up to 4k resolution \"audioOnly\": Generates an m4a audio file of the media file \"audioOnly,capped_4k\": Generates both video and audio media files for offline viewing

"""


CreateMediaRequestMaxResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The maximum resolution tier determines the highest quality your media will be available in.

"""


class SummaryTypedDict(TypedDict):
    generate: bool
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """
    summary_length: NotRequired[int]
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class Summary(BaseModel):
    generate: bool
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """

    summary_length: Annotated[Optional[int], pydantic.Field(alias="summaryLength")] = (
        100
    )
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class ModerationTypedDict(TypedDict):
    type: MediaType
    r"""Type of media content"""


class Moderation(BaseModel):
    type: MediaType
    r"""Type of media content"""


class CreateMediaRequestDomainsTypedDict(TypedDict):
    default_policy: NotRequired[PolicyAction]
    r"""Policy action type"""
    allow: NotRequired[List[str]]
    r"""A list of domain names or patterns that are explicitly allowed access.
    This list is only effective when the `defaultPolicy` is set to `deny`.

    """
    deny: NotRequired[List[str]]
    r"""A list of domain names or patterns that are explicitly denied access.
    This list is only effective when the `defaultPolicy` is set to `allow`.

    """


class CreateMediaRequestDomains(BaseModel):
    default_policy: Annotated[
        Optional[PolicyAction], pydantic.Field(alias="defaultPolicy")
    ] = None
    r"""Policy action type"""

    allow: Optional[List[str]] = None
    r"""A list of domain names or patterns that are explicitly allowed access.
    This list is only effective when the `defaultPolicy` is set to `deny`.

    """

    deny: Optional[List[str]] = None
    r"""A list of domain names or patterns that are explicitly denied access.
    This list is only effective when the `defaultPolicy` is set to `allow`.

    """


class CreateMediaRequestUserAgentsTypedDict(TypedDict):
    default_policy: NotRequired[PolicyAction]
    r"""Policy action type"""
    allow: NotRequired[List[str]]
    r"""A list of user agents (identified by string names or patterns) that are explicitly allowed access.
    This list is only effective when the `defaultPolicy` is set to `deny`.

    """
    deny: NotRequired[List[str]]
    r"""A list of user agents (identified by string names or patterns) that are explicitly denied access.
    This list is only effective when the `defaultPolicy` is set to `allow`.

    """


class CreateMediaRequestUserAgents(BaseModel):
    default_policy: Annotated[
        Optional[PolicyAction], pydantic.Field(alias="defaultPolicy")
    ] = None
    r"""Policy action type"""

    allow: Optional[List[str]] = None
    r"""A list of user agents (identified by string names or patterns) that are explicitly allowed access.
    This list is only effective when the `defaultPolicy` is set to `deny`.

    """

    deny: Optional[List[str]] = None
    r"""A list of user agents (identified by string names or patterns) that are explicitly denied access.
    This list is only effective when the `defaultPolicy` is set to `allow`.

    """


class CreateMediaRequestAccessRestrictionsTypedDict(TypedDict):
    domains: NotRequired[CreateMediaRequestDomainsTypedDict]
    user_agents: NotRequired[CreateMediaRequestUserAgentsTypedDict]


class CreateMediaRequestAccessRestrictions(BaseModel):
    domains: Optional[CreateMediaRequestDomains] = None

    user_agents: Annotated[
        Optional[CreateMediaRequestUserAgents], pydantic.Field(alias="userAgents")
    ] = None


class CreateMediaRequestTypedDict(TypedDict):
    inputs: List[InputTypedDict]
    access_policy: CreateMediaRequestAccessPolicy
    r"""Determines whether access to the streamed content is kept private or available to all.

    """
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    subtitles: NotRequired[SubtitlesTypedDict]
    r"""Generates subtitle files for audio/video files.

    """
    mp4_support: NotRequired[CreateMediaRequestMp4Support]
    r"""\"capped_4k\": Generates an mp4 video file up to 4k resolution \"audioOnly\": Generates an m4a audio file of the media file \"audioOnly,capped_4k\": Generates both video and audio media files for offline viewing

    """
    source_access: NotRequired[bool]
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""
    optimize_audio: NotRequired[bool]
    r"""normalize volume of the audio track. This is available for pre-recorded content only.

    """
    max_resolution: NotRequired[CreateMediaRequestMaxResolution]
    r"""The maximum resolution tier determines the highest quality your media will be available in.

    """
    summary: NotRequired[SummaryTypedDict]
    chapters: NotRequired[bool]
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """
    named_entities: NotRequired[bool]
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """
    moderation: NotRequired[ModerationTypedDict]
    access_restrictions: NotRequired[CreateMediaRequestAccessRestrictionsTypedDict]


class CreateMediaRequest(BaseModel):
    inputs: List[Input]

    access_policy: Annotated[
        CreateMediaRequestAccessPolicy, pydantic.Field(alias="accessPolicy")
    ]
    r"""Determines whether access to the streamed content is kept private or available to all.

    """

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    subtitles: Optional[Subtitles] = None
    r"""Generates subtitle files for audio/video files.

    """

    mp4_support: Annotated[
        Optional[CreateMediaRequestMp4Support], pydantic.Field(alias="mp4Support")
    ] = None
    r"""\"capped_4k\": Generates an mp4 video file up to 4k resolution \"audioOnly\": Generates an m4a audio file of the media file \"audioOnly,capped_4k\": Generates both video and audio media files for offline viewing

    """

    source_access: Annotated[Optional[bool], pydantic.Field(alias="sourceAccess")] = (
        None
    )
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""

    optimize_audio: Annotated[Optional[bool], pydantic.Field(alias="optimizeAudio")] = (
        False
    )
    r"""normalize volume of the audio track. This is available for pre-recorded content only.

    """

    max_resolution: Annotated[
        Optional[CreateMediaRequestMaxResolution], pydantic.Field(alias="maxResolution")
    ] = "1080p"
    r"""The maximum resolution tier determines the highest quality your media will be available in.

    """

    summary: Optional[Summary] = None

    chapters: Optional[bool] = None
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """

    named_entities: Annotated[Optional[bool], pydantic.Field(alias="namedEntities")] = (
        None
    )
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """

    moderation: Optional[Moderation] = None

    access_restrictions: Annotated[
        Optional[CreateMediaRequestAccessRestrictions],
        pydantic.Field(alias="accessRestrictions"),
    ] = None
