"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .playbackid import PlaybackID, PlaybackIDTypedDict
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CreateMediaResponseMaxResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The maximum resolution tier determines the highest quality your media will be available in."""


class CreateMediaResponseTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The Media is assigned a universal unique identifier, which can contain a maximum of 255 characters."""
    trial: NotRequired[bool]
    r"""FastPix allows for a free trial. Create as many media files as you like during the trial period. Remember, each clip can only be 10 seconds long and will be deleted after 24 hours. Also, all trial content will have the FastPix logo watermark.

    """
    status: NotRequired[str]
    r"""Determines the media's status, which can be one of the possible values."""
    created_at: NotRequired[datetime]
    r"""Time the media was created, defined as a localDateTime (UTC Time)."""
    updated_at: NotRequired[datetime]
    r"""Time the media was updated, defined as a localDateTime (UTC Time)."""
    playback_ids: NotRequired[List[PlaybackIDTypedDict]]
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    max_resolution: NotRequired[CreateMediaResponseMaxResolution]
    r"""The maximum resolution tier determines the highest quality your media will be available in."""


class CreateMediaResponse(BaseModel):
    id: Optional[str] = None
    r"""The Media is assigned a universal unique identifier, which can contain a maximum of 255 characters."""

    trial: Optional[bool] = True
    r"""FastPix allows for a free trial. Create as many media files as you like during the trial period. Remember, each clip can only be 10 seconds long and will be deleted after 24 hours. Also, all trial content will have the FastPix logo watermark.

    """

    status: Optional[str] = None
    r"""Determines the media's status, which can be one of the possible values."""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Time the media was created, defined as a localDateTime (UTC Time)."""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Time the media was updated, defined as a localDateTime (UTC Time)."""

    playback_ids: Annotated[
        Optional[List[PlaybackID]], pydantic.Field(alias="playbackIds")
    ] = None
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    max_resolution: Annotated[
        Optional[CreateMediaResponseMaxResolution],
        pydantic.Field(alias="maxResolution"),
    ] = "1080p"
    r"""The maximum resolution tier determines the highest quality your media will be available in."""
