"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .daterange import DateRange, DateRangeTypedDict
from .playlistorder import PlaylistOrder
from ..types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CreatePlaylistRequestType = Literal[
    "smart",
    "manual",
]
r"""For a smart playlist metadata is required."""


class CreatePlaylistRequestMetadataTypedDict(TypedDict):
    r"""Required when playlist type is smart - media created between startDate and endDate of createdDate will be add, similarily updatedDate (Optional)"""

    created_date: NotRequired[DateRangeTypedDict]
    r"""Date range with start and end dates."""
    updated_date: NotRequired[DateRangeTypedDict]
    r"""Date range with start and end dates."""


class CreatePlaylistRequestMetadata(BaseModel):
    r"""Required when playlist type is smart - media created between startDate and endDate of createdDate will be add, similarily updatedDate (Optional)"""

    created_date: Annotated[
        Optional[DateRange], pydantic.Field(alias="createdDate")
    ] = None
    r"""Date range with start and end dates."""

    updated_date: Annotated[
        Optional[DateRange], pydantic.Field(alias="updatedDate")
    ] = None
    r"""Date range with start and end dates."""


class CreatePlaylistRequestTypedDict(TypedDict):
    name: str
    r"""Name of the playlist."""
    reference_id: str
    r"""Unique string value assigned by user to the playlist."""
    type: CreatePlaylistRequestType
    r"""For a smart playlist metadata is required."""
    description: NotRequired[str]
    r"""Description for a playlist (Optional)."""
    play_order: NotRequired[PlaylistOrder]
    r"""Determines the insertion order of media into playlist."""
    limit: NotRequired[int]
    r"""Optional parameter to limit no. of media in a playlist."""
    metadata: NotRequired[CreatePlaylistRequestMetadataTypedDict]
    r"""Required when playlist type is smart - media created between startDate and endDate of createdDate will be add, similarily updatedDate (Optional)"""


class CreatePlaylistRequest(BaseModel):
    name: str
    r"""Name of the playlist."""

    reference_id: Annotated[str, pydantic.Field(alias="referenceId")]
    r"""Unique string value assigned by user to the playlist."""

    type: CreatePlaylistRequestType
    r"""For a smart playlist metadata is required."""

    description: Optional[str] = None
    r"""Description for a playlist (Optional)."""

    play_order: Annotated[
        Optional[PlaylistOrder], pydantic.Field(alias="playOrder")
    ] = None
    r"""Determines the insertion order of media into playlist."""

    limit: Optional[int] = 1000
    r"""Optional parameter to limit no. of media in a playlist."""

    metadata: Optional[CreatePlaylistRequestMetadata] = None
    r"""Required when playlist type is smart - media created between startDate and endDate of createdDate will be add, similarily updatedDate (Optional)"""
