"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DataPaginationTypedDict(TypedDict):
    r"""Pagination organizes content into pages for better readability and navigation."""

    total_records: NotRequired[int]
    r"""The total number of records retrieved within the timeframe.

    """
    current_offset: NotRequired[int]
    r"""The current offset value.

    Default: 1

    """
    offset_count: NotRequired[int]
    r"""The total number of offsets based on limit.

    """


class DataPagination(BaseModel):
    r"""Pagination organizes content into pages for better readability and navigation."""

    total_records: Annotated[Optional[int], pydantic.Field(alias="totalRecords")] = None
    r"""The total number of records retrieved within the timeframe.

    """

    current_offset: Annotated[Optional[int], pydantic.Field(alias="currentOffset")] = (
        None
    )
    r"""The current offset value.

    Default: 1

    """

    offset_count: Annotated[Optional[int], pydantic.Field(alias="offsetCount")] = None
    r"""The total number of offsets based on limit.

    """
