"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .audioinput import AudioInput, AudioInputTypedDict
from .basicaccesspolicy import BasicAccessPolicy
from .directupload import DirectUpload, DirectUploadTypedDict
from .domainrestrictions import DomainRestrictions, DomainRestrictionsTypedDict
from .mediatype import MediaType
from .subtitleinput import SubtitleInput, SubtitleInputTypedDict
from .useragentrestrictions import UserAgentRestrictions, UserAgentRestrictionsTypedDict
from .videoinput import VideoInput, VideoInputTypedDict
from .watermarkinput import WatermarkInput, WatermarkInputTypedDict
from ..types import BaseModel
import pydantic
from typing import Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


DirectUploadVideoMediaInputTypedDict = TypeAliasType(
    "DirectUploadVideoMediaInputTypedDict",
    Union[
        AudioInputTypedDict,
        SubtitleInputTypedDict,
        WatermarkInputTypedDict,
        VideoInputTypedDict,
    ],
)


DirectUploadVideoMediaInput = TypeAliasType(
    "DirectUploadVideoMediaInput",
    Union[AudioInput, SubtitleInput, WatermarkInput, VideoInput],
)


DirectUploadVideoMediaLanguageCode = Literal[
    "en",
    "it",
    "pl",
    "es",
    "fr",
    "ru",
    "nl",
]
r"""Language codes (BCP 47 compliant) used for text files.

"""


class DirectUploadVideoMediaSubtitlesTypedDict(TypedDict):
    r"""Generates subtitle files for audio/video files."""

    language_name: NotRequired[str]
    r"""Name of the language for the subtitles."""
    metadata: NotRequired[Dict[str, str]]
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""
    language_code: NotRequired[DirectUploadVideoMediaLanguageCode]
    r"""Language codes (BCP 47 compliant) used for text files.

    """


class DirectUploadVideoMediaSubtitles(BaseModel):
    r"""Generates subtitle files for audio/video files."""

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""Name of the language for the subtitles."""

    metadata: Optional[Dict[str, str]] = None
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""

    language_code: Annotated[
        Optional[DirectUploadVideoMediaLanguageCode],
        pydantic.Field(alias="languageCode"),
    ] = None
    r"""Language codes (BCP 47 compliant) used for text files.

    """


DirectUploadVideoMediaMaxResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""Determines the highest quality resolution available.

"""


DirectUploadVideoMediaMp4Support = Literal[
    "capped_4k",
    "audioOnly",
    "audioOnly,capped_4k",
]
r"""Generates MP4 video up to 4K (\"capped_4k\"), m4a audio only (\"audioOnly\"), or both for offline viewing.

"""


class DirectUploadVideoMediaSummaryTypedDict(TypedDict):
    generate: NotRequired[bool]
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """
    summary_length: NotRequired[int]
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class DirectUploadVideoMediaSummary(BaseModel):
    generate: Optional[bool] = None
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """

    summary_length: Annotated[Optional[int], pydantic.Field(alias="summaryLength")] = (
        100
    )
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class DirectUploadVideoMediaModerationTypedDict(TypedDict):
    type: NotRequired[MediaType]
    r"""Type of media content"""


class DirectUploadVideoMediaModeration(BaseModel):
    type: Optional[MediaType] = None
    r"""Type of media content"""


class DirectUploadVideoMediaAccessRestrictionsTypedDict(TypedDict):
    domains: NotRequired[DomainRestrictionsTypedDict]
    r"""Restrictions based on the originating domain of a request"""
    user_agents: NotRequired[UserAgentRestrictionsTypedDict]
    r"""Restrictions based on the user agent"""


class DirectUploadVideoMediaAccessRestrictions(BaseModel):
    domains: Optional[DomainRestrictions] = None
    r"""Restrictions based on the originating domain of a request"""

    user_agents: Annotated[
        Optional[UserAgentRestrictions], pydantic.Field(alias="userAgents")
    ] = None
    r"""Restrictions based on the user agent"""


class PushMediaSettingsTypedDict(TypedDict):
    r"""Configuration settings for media upload."""

    access_policy: BasicAccessPolicy
    r"""Basic access policy for media content"""
    start_time: NotRequired[float]
    r"""Start time indicates where encoding should begin within the video file, in seconds."""
    end_time: NotRequired[float]
    r"""End time indicates where encoding should end within the video file, in seconds."""
    inputs: NotRequired[List[DirectUploadVideoMediaInputTypedDict]]
    metadata: NotRequired[Dict[str, str]]
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""
    subtitles: NotRequired[DirectUploadVideoMediaSubtitlesTypedDict]
    r"""Generates subtitle files for audio/video files.

    """
    optimize_audio: NotRequired[bool]
    r"""Enhance the quality and volume of the audio track. This is available for pre-recorded content only.

    """
    max_resolution: NotRequired[DirectUploadVideoMediaMaxResolution]
    r"""Determines the highest quality resolution available.

    """
    source_access: NotRequired[bool]
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""
    mp4_support: NotRequired[DirectUploadVideoMediaMp4Support]
    r"""Generates MP4 video up to 4K (\"capped_4k\"), m4a audio only (\"audioOnly\"), or both for offline viewing.

    """
    summary: NotRequired[DirectUploadVideoMediaSummaryTypedDict]
    chapters: NotRequired[bool]
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """
    named_entities: NotRequired[bool]
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """
    moderation: NotRequired[DirectUploadVideoMediaModerationTypedDict]
    access_restrictions: NotRequired[DirectUploadVideoMediaAccessRestrictionsTypedDict]


class PushMediaSettings(BaseModel):
    r"""Configuration settings for media upload."""

    access_policy: Annotated[BasicAccessPolicy, pydantic.Field(alias="accessPolicy")]
    r"""Basic access policy for media content"""

    start_time: Annotated[Optional[float], pydantic.Field(alias="startTime")] = None
    r"""Start time indicates where encoding should begin within the video file, in seconds."""

    end_time: Annotated[Optional[float], pydantic.Field(alias="endTime")] = None
    r"""End time indicates where encoding should end within the video file, in seconds."""

    inputs: Optional[List[DirectUploadVideoMediaInput]] = None

    metadata: Optional[Dict[str, str]] = None
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""

    subtitles: Optional[DirectUploadVideoMediaSubtitles] = None
    r"""Generates subtitle files for audio/video files.

    """

    optimize_audio: Annotated[Optional[bool], pydantic.Field(alias="optimizeAudio")] = (
        True
    )
    r"""Enhance the quality and volume of the audio track. This is available for pre-recorded content only.

    """

    max_resolution: Annotated[
        Optional[DirectUploadVideoMediaMaxResolution],
        pydantic.Field(alias="maxResolution"),
    ] = "1080p"
    r"""Determines the highest quality resolution available.

    """

    source_access: Annotated[Optional[bool], pydantic.Field(alias="sourceAccess")] = (
        None
    )
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""

    mp4_support: Annotated[
        Optional[DirectUploadVideoMediaMp4Support], pydantic.Field(alias="mp4Support")
    ] = None
    r"""Generates MP4 video up to 4K (\"capped_4k\"), m4a audio only (\"audioOnly\"), or both for offline viewing.

    """

    summary: Optional[DirectUploadVideoMediaSummary] = None

    chapters: Optional[bool] = None
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """

    named_entities: Annotated[Optional[bool], pydantic.Field(alias="namedEntities")] = (
        None
    )
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """

    moderation: Optional[DirectUploadVideoMediaModeration] = None

    access_restrictions: Annotated[
        Optional[DirectUploadVideoMediaAccessRestrictions],
        pydantic.Field(alias="accessRestrictions"),
    ] = None


class DirectUploadVideoMediaRequestTypedDict(TypedDict):
    r"""Request body for direct upload"""

    cors_origin: str
    r"""Upload media directly from a device using the URL name or enter '*' to allow all."""
    push_media_settings: NotRequired[PushMediaSettingsTypedDict]
    r"""Configuration settings for media upload."""


class DirectUploadVideoMediaRequest(BaseModel):
    r"""Request body for direct upload"""

    cors_origin: Annotated[str, pydantic.Field(alias="corsOrigin")]
    r"""Upload media directly from a device using the URL name or enter '*' to allow all."""

    push_media_settings: Annotated[
        Optional[PushMediaSettings], pydantic.Field(alias="pushMediaSettings")
    ] = None
    r"""Configuration settings for media upload."""


class DirectUploadVideoMediaResponseTypedDict(TypedDict):
    r"""Direct upload created successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[DirectUploadTypedDict]
    r"""Displays the result of the request."""


class DirectUploadVideoMediaResponse(BaseModel):
    r"""Direct upload created successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[DirectUpload] = None
    r"""Displays the result of the request."""
