"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .directuploadresponse import DirectUploadResponse, DirectUploadResponseTypedDict
from ..types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DirectUploadTypedDict(TypedDict):
    r"""Displays the result of the request."""

    id: NotRequired[str]
    r"""When creating the upload, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    media_id: NotRequired[str]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    status: NotRequired[str]
    r"""Determines the media's status, which can be one of the possible values."""
    url: NotRequired[str]
    r"""The url hosts the media file for FastPix, which needs to be download to use further.  It supports formats like MP3, MP4, MOV, MKV, or TS, and includes text tracks for subtitles/CC (SRT file/VTT file). While FastPix can handle various audio and video formats and codecs, using standard inputs can help with optimal processing speed."""
    timeout: NotRequired[float]
    r"""The duration set for the validity of the upload URL. If the upload isn't completed within this timeframe, it's marked as timed out.

    """
    cors_origin: NotRequired[str]
    r"""Upload media directly from a device using the url name or enter '*' to allow all."""
    push_media_settings: NotRequired[DirectUploadResponseTypedDict]


class DirectUpload(BaseModel):
    r"""Displays the result of the request."""

    id: Optional[str] = None
    r"""When creating the upload, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    media_id: Annotated[Optional[str], pydantic.Field(alias="mediaId")] = None
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    status: Optional[str] = None
    r"""Determines the media's status, which can be one of the possible values."""

    url: Optional[str] = None
    r"""The url hosts the media file for FastPix, which needs to be download to use further.  It supports formats like MP3, MP4, MOV, MKV, or TS, and includes text tracks for subtitles/CC (SRT file/VTT file). While FastPix can handle various audio and video formats and codecs, using standard inputs can help with optimal processing speed."""

    timeout: Optional[float] = 14400
    r"""The duration set for the validity of the upload URL. If the upload isn't completed within this timeframe, it's marked as timed out.

    """

    cors_origin: Annotated[Optional[str], pydantic.Field(alias="corsOrigin")] = None
    r"""Upload media directly from a device using the url name or enter '*' to allow all."""

    push_media_settings: Annotated[
        Optional[DirectUploadResponse], pydantic.Field(alias="pushMediaSettings")
    ] = None
