"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ErrorDetailsPercentageTypedDict = TypeAliasType(
    "ErrorDetailsPercentageTypedDict", Union[int, float]
)
r"""views affected by the specific errors."""


ErrorDetailsPercentage = TypeAliasType("ErrorDetailsPercentage", Union[int, float])
r"""views affected by the specific errors."""


class ErrorDetailsTypedDict(TypedDict):
    percentage: NotRequired[Nullable[ErrorDetailsPercentageTypedDict]]
    r"""views affected by the specific errors."""
    notes: NotRequired[Nullable[str]]
    r"""Information about the specific error."""
    message: NotRequired[Nullable[str]]
    r"""error message or description."""
    last_seen: NotRequired[Nullable[str]]
    r"""The timestamp of when the error was last observed."""
    id: NotRequired[Nullable[str]]
    r"""unique identifier for the specific error."""
    description: NotRequired[Nullable[str]]
    r"""description of the specific error."""
    count: NotRequired[Nullable[int]]
    r"""Number of occurrences of the specific error."""
    code: NotRequired[Nullable[str]]
    r"""Error code associated with the specific error."""


class ErrorDetails(BaseModel):
    percentage: OptionalNullable[ErrorDetailsPercentage] = UNSET
    r"""views affected by the specific errors."""

    notes: OptionalNullable[str] = UNSET
    r"""Information about the specific error."""

    message: OptionalNullable[str] = UNSET
    r"""error message or description."""

    last_seen: Annotated[OptionalNullable[str], pydantic.Field(alias="lastSeen")] = (
        UNSET
    )
    r"""The timestamp of when the error was last observed."""

    id: OptionalNullable[str] = UNSET
    r"""unique identifier for the specific error."""

    description: OptionalNullable[str] = UNSET
    r"""description of the specific error."""

    count: OptionalNullable[int] = UNSET
    r"""Number of occurrences of the specific error."""

    code: OptionalNullable[str] = UNSET
    r"""Error code associated with the specific error."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "percentage",
            "notes",
            "message",
            "lastSeen",
            "id",
            "description",
            "count",
            "code",
        ]
        nullable_fields = [
            "percentage",
            "notes",
            "message",
            "lastSeen",
            "id",
            "description",
            "count",
            "code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
