"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .generatetrackresponse import GenerateTrackResponse, GenerateTrackResponseTypedDict
from .tracksubtitlesgeneraterequest import (
    TrackSubtitlesGenerateRequest,
    TrackSubtitlesGenerateRequestTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GenerateSubtitleTrackRequestTypedDict(TypedDict):
    media_id: str
    r"""A universally unique identifier (UUID) assigned to the media by FastPix."""
    track_id: str
    r"""A universally unique identifier (UUID) assigned to the specific track for which subtitles should be generated."""
    track_subtitles_generate_request: TrackSubtitlesGenerateRequestTypedDict


class GenerateSubtitleTrackRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""A universally unique identifier (UUID) assigned to the media by FastPix."""

    track_id: Annotated[
        str,
        pydantic.Field(alias="trackId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""A universally unique identifier (UUID) assigned to the specific track for which subtitles should be generated."""

    track_subtitles_generate_request: Annotated[
        TrackSubtitlesGenerateRequest,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class GenerateSubtitleTrackResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[GenerateTrackResponseTypedDict]
    r"""Represents the response for a successfully generated subtitle track."""


class GenerateSubtitleTrackResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[GenerateTrackResponse] = None
    r"""Represents the response for a successfully generated subtitle track."""
