"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Dict, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GenerateTrackResponseType = Literal["subtitle",]
r"""The type of track generated (\"subtitle\")."""


GenerateTrackResponseLanguageCode = Literal[
    "ar-SA",
    "bn-BD",
    "bn-IN",
    "ca-ES",
    "cs-CZ",
    "da-DK",
    "de-AT",
    "de-CH",
    "de-DE",
    "el-GR",
    "en-AU",
    "en-CA",
    "en-GB",
    "en-IE",
    "en-IN",
    "en-NZ",
    "en-US",
    "en-ZA",
    "es-AR",
    "es-CL",
    "es-CO",
    "es-ES",
    "es-MX",
    "es-US",
    "fi-FI",
    "fr-BE",
    "fr-CA",
    "fr-CH",
    "fr-FR",
    "he-IL",
    "hi-IN",
    "hr-HR",
    "hu-HU",
    "id-ID",
    "it-CH",
    "it-IT",
    "ja-JP",
    "ko-KR",
    "nl-BE",
    "nl-NL",
    "no-NO",
    "pl-PL",
    "pt-BR",
    "pt-PT",
    "ro-RO",
    "ru-RU",
    "sk-SK",
    "sv-SE",
    "ta-IN",
    "ta-LK",
    "th-TH",
    "tr-TR",
    "uk-UA",
    "bg-BG",
    "zh-CN",
    "zh-HK",
    "zh-TW",
]
r"""The BCP 47 language code representing the language of the generated track.

"""


class GenerateTrackResponseTypedDict(TypedDict):
    r"""Represents the response for a successfully generated subtitle track."""

    id: NotRequired[str]
    r"""A unique identifier for the generated track."""
    type: NotRequired[GenerateTrackResponseType]
    r"""The type of track generated (\"subtitle\")."""
    language_code: NotRequired[GenerateTrackResponseLanguageCode]
    r"""The BCP 47 language code representing the language of the generated track.

    """
    language_name: NotRequired[str]
    r"""The full name of the language for the generated track."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class GenerateTrackResponse(BaseModel):
    r"""Represents the response for a successfully generated subtitle track."""

    id: Optional[str] = None
    r"""A unique identifier for the generated track."""

    type: Optional[GenerateTrackResponseType] = None
    r"""The type of track generated (\"subtitle\")."""

    language_code: Annotated[
        Optional[GenerateTrackResponseLanguageCode],
        pydantic.Field(alias="languageCode"),
    ] = None
    r"""The BCP 47 language code representing the language of the generated track.

    """

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""The full name of the language for the generated track."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
