"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GetDataViewlistCurrentViewsFilterDimension = Literal[
    "country",
    "region",
    "asn_id",
    "cdn",
    "video_title",
    "video_series",
    "video_id",
    "sub_property_id",
    "video_source_stream_type",
    "os_name",
    "player_name",
    "media_id",
    "fp_playback_id",
    "view_id",
]
r"""The dimension to group and breakdown the concurrent viewers data by.
This determines how the results will be categorized and aggregated.
Choose from geographic, content, technical, or behavioral dimensions.

"""


class GetDataViewlistCurrentViewsFilterRequestTypedDict(TypedDict):
    dimension: NotRequired[GetDataViewlistCurrentViewsFilterDimension]
    r"""The dimension to group and breakdown the concurrent viewers data by.
    This determines how the results will be categorized and aggregated.
    Choose from geographic, content, technical, or behavioral dimensions.

    """
    limit: NotRequired[int]
    r"""Maximum number of results to return. Controls the number of dimension values
    that will be included in the response. Useful for pagination and performance.
    Higher limits provide more detailed breakdowns but may impact response time.

    """


class GetDataViewlistCurrentViewsFilterRequest(BaseModel):
    dimension: Annotated[
        Optional[GetDataViewlistCurrentViewsFilterDimension],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The dimension to group and breakdown the concurrent viewers data by.
    This determines how the results will be categorized and aggregated.
    Choose from geographic, content, technical, or behavioral dimensions.

    """

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Maximum number of results to return. Controls the number of dimension values
    that will be included in the response. Useful for pagination and performance.
    Higher limits provide more detailed breakdowns but may impact response time.

    """


class GetDataViewlistCurrentViewsFilterDataTypedDict(TypedDict):
    concurrent_viewers: NotRequired[int]
    r"""Number of concurrent viewers for this dimension value."""
    dimension_name: NotRequired[str]
    r"""Name of the dimension (e.g., country, device type, etc.)."""
    metric_value: NotRequired[int]
    r"""Additional metric value for this dimension (if applicable)."""


class GetDataViewlistCurrentViewsFilterData(BaseModel):
    concurrent_viewers: Optional[int] = None
    r"""Number of concurrent viewers for this dimension value."""

    dimension_name: Optional[str] = None
    r"""Name of the dimension (e.g., country, device type, etc.)."""

    metric_value: Annotated[Optional[int], pydantic.Field(alias="metricValue")] = None
    r"""Additional metric value for this dimension (if applicable)."""


class GetDataViewlistCurrentViewsFilterResponseTypedDict(TypedDict):
    r"""Successfully retrieved concurrent viewers breakdown by the specified dimension."""

    success: NotRequired[bool]
    r"""Indicates if the request was successful."""
    data: NotRequired[List[GetDataViewlistCurrentViewsFilterDataTypedDict]]
    r"""Breakdown of concurrent viewers by the specified dimension."""
    timespan: NotRequired[List[int]]
    r"""Start and end epoch timestamps (milliseconds) for the timespan window."""


class GetDataViewlistCurrentViewsFilterResponse(BaseModel):
    r"""Successfully retrieved concurrent viewers breakdown by the specified dimension."""

    success: Optional[bool] = None
    r"""Indicates if the request was successful."""

    data: Optional[List[GetDataViewlistCurrentViewsFilterData]] = None
    r"""Breakdown of concurrent viewers by the specified dimension."""

    timespan: Optional[List[int]] = None
    r"""Start and end epoch timestamps (milliseconds) for the timespan window."""
