"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetDataViewlistCurrentViewsGetTimeseriesViewsDataTypedDict(TypedDict):
    interval_time: NotRequired[datetime]
    r"""The timestamp for the interval (ISO 8601 format)."""
    metric_value: NotRequired[Nullable[int]]
    r"""Reserved for future metric values (currently null)."""
    number_of_views: NotRequired[int]
    r"""Number of concurrent viewers at the given interval."""


class GetDataViewlistCurrentViewsGetTimeseriesViewsData(BaseModel):
    interval_time: Annotated[
        Optional[datetime], pydantic.Field(alias="intervalTime")
    ] = None
    r"""The timestamp for the interval (ISO 8601 format)."""

    metric_value: Annotated[
        OptionalNullable[int], pydantic.Field(alias="metricValue")
    ] = UNSET
    r"""Reserved for future metric values (currently null)."""

    number_of_views: Annotated[Optional[int], pydantic.Field(alias="numberOfViews")] = (
        None
    )
    r"""Number of concurrent viewers at the given interval."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["intervalTime", "metricValue", "numberOfViews"]
        nullable_fields = ["metricValue"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetDataViewlistCurrentViewsGetTimeseriesViewsResponseTypedDict(TypedDict):
    r"""Successfully retrieved concurrent viewers timeseries."""

    success: NotRequired[bool]
    r"""Indicates if the request was successful."""
    data: NotRequired[List[GetDataViewlistCurrentViewsGetTimeseriesViewsDataTypedDict]]
    r"""Time series data for concurrent viewers."""
    timespan: NotRequired[List[int]]
    r"""Start and end epoch timestamps (milliseconds) for the timeseries window."""


class GetDataViewlistCurrentViewsGetTimeseriesViewsResponse(BaseModel):
    r"""Successfully retrieved concurrent viewers timeseries."""

    success: Optional[bool] = None
    r"""Indicates if the request was successful."""

    data: Optional[List[GetDataViewlistCurrentViewsGetTimeseriesViewsData]] = None
    r"""Time series data for concurrent viewers."""

    timespan: Optional[List[int]] = None
    r"""Start and end epoch timestamps (milliseconds) for the timeseries window."""
